/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.writer.GSCommitRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSCommitRecoverableSerializer
implements SimpleVersionedSerializer<GSCommitRecoverable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSCommitRecoverableSerializer.class);
    private static final int SERIALIZER_VERSION = 1;
    public static final GSCommitRecoverableSerializer INSTANCE = new GSCommitRecoverableSerializer();

    private GSCommitRecoverableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    static void serializeCommitRecoverable(GSCommitRecoverable recoverable, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(recoverable.finalBlobIdentifier.bucketName);
        dataOutputStream.writeUTF(recoverable.finalBlobIdentifier.objectName);
        dataOutputStream.writeInt(recoverable.componentObjectIds.size());
        for (UUID componentObjectId : recoverable.componentObjectIds) {
            dataOutputStream.writeLong(componentObjectId.getMostSignificantBits());
            dataOutputStream.writeLong(componentObjectId.getLeastSignificantBits());
        }
    }

    public byte[] serialize(GSCommitRecoverable recoverable) throws IOException {
        LOGGER.trace("Serializing recoverable {}", (Object)recoverable);
        Preconditions.checkNotNull((Object)recoverable);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                GSCommitRecoverableSerializer.serializeCommitRecoverable(recoverable, dataOutputStream);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    static GSCommitRecoverable deserializeCommitRecoverable(DataInputStream dataInputStream) throws IOException {
        String finalBucketName = dataInputStream.readUTF();
        String finalObjectName = dataInputStream.readUTF();
        GSBlobIdentifier finalBlobIdentifier = new GSBlobIdentifier(finalBucketName, finalObjectName);
        ArrayList<UUID> componentObjectIds = new ArrayList<UUID>();
        int count = dataInputStream.readInt();
        for (int i = 0; i < count; ++i) {
            long msbValue = dataInputStream.readLong();
            long lsbValue = dataInputStream.readLong();
            UUID componentObjectId = new UUID(msbValue, lsbValue);
            componentObjectIds.add(componentObjectId);
        }
        GSCommitRecoverable recoverable = new GSCommitRecoverable(finalBlobIdentifier, componentObjectIds);
        LOGGER.trace("Deserialized commit recoverable {}", (Object)recoverable);
        return recoverable;
    }

    public GSCommitRecoverable deserialize(int version, byte[] serialized) throws IOException {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)serialized);
        if (version > 1) {
            throw new IOException(String.format("Serialized data with version %d cannot be read by serializer with version %d", version, 1));
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(serialized);){
            GSCommitRecoverable gSCommitRecoverable;
            try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                gSCommitRecoverable = GSCommitRecoverableSerializer.deserializeCommitRecoverable(dataInputStream);
            }
            return gSCommitRecoverable;
        }
    }
}

