/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class JsonQuoteFunction
extends BuiltInScalarFunction {
    public JsonQuoteFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.JSON_QUOTE, context);
    }

    @Nullable
    public Object eval(Object input) {
        if (input == null) {
            return null;
        }
        BinaryStringData bs = (BinaryStringData)input;
        String stringWithoutQuotes = JsonQuoteFunction.quote(bs.toString());
        String outputVal = String.format("\"%s\"", stringWithoutQuotes);
        return new BinaryStringData(outputVal);
    }

    private static String quote(String input) {
        StringBuilder outputStr = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            int codePoint = input.codePointAt(i);
            if (codePoint < 128) {
                JsonQuoteFunction.appendASCII(outputStr, (char)codePoint);
                continue;
            }
            outputStr.append(String.format("\\u%04x", codePoint));
        }
        return outputStr.toString();
    }

    private static void appendASCII(StringBuilder outputStr, char ch) {
        switch (ch) {
            case '\"': {
                outputStr.append("\\\"");
                break;
            }
            case '\\': {
                outputStr.append("\\\\");
                break;
            }
            case '/': {
                outputStr.append("\\/");
                break;
            }
            case '\b': {
                outputStr.append("\\b");
                break;
            }
            case '\f': {
                outputStr.append("\\f");
                break;
            }
            case '\n': {
                outputStr.append("\\n");
                break;
            }
            case '\r': {
                outputStr.append("\\r");
                break;
            }
            case '\t': {
                outputStr.append("\\t");
                break;
            }
            default: {
                outputStr.append(ch);
            }
        }
    }
}

