/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAlterModel;

public class SqlAlterModelRename
extends SqlAlterModel {
    private final SqlIdentifier newModelName;

    public SqlAlterModelRename(SqlParserPos pos, SqlIdentifier modelName, SqlIdentifier newModelName, boolean ifModelExists) {
        super(pos, modelName, ifModelExists);
        this.newModelName = Objects.requireNonNull(newModelName, "newModelName should not be null");
    }

    public SqlIdentifier getNewModelName() {
        return this.newModelName;
    }

    public String[] fullNewModelName() {
        return this.newModelName.names.toArray(new String[0]);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return List.of(this.modelName, this.newModelName);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("RENAME TO");
        this.newModelName.unparse(writer, leftPrec, rightPrec);
    }
}

