/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ModelProviderFactory;
import org.apache.flink.table.ml.ModelProvider;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.planner.calcite.FlinkCalciteSqlValidator;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexModelCall;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.OptionalUtils;

public class CatalogSchemaModel {
    private final ContextResolvedModel contextResolvedModel;

    public CatalogSchemaModel(ContextResolvedModel contextResolvedModel) {
        this.contextResolvedModel = contextResolvedModel;
    }

    public ContextResolvedModel getContextResolvedModel() {
        return this.contextResolvedModel;
    }

    public boolean isTemporary() {
        return this.contextResolvedModel.isTemporary();
    }

    public RelDataType getInputRowType(RelDataTypeFactory typeFactory) {
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        ResolvedSchema schema = this.contextResolvedModel.getResolvedModel().getResolvedInputSchema();
        return CatalogSchemaModel.schemaToRelDataType(flinkTypeFactory, schema);
    }

    public RelDataType getOutputRowType(RelDataTypeFactory typeFactory) {
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        ResolvedSchema schema = this.contextResolvedModel.getResolvedModel().getResolvedOutputSchema();
        return CatalogSchemaModel.schemaToRelDataType(flinkTypeFactory, schema);
    }

    public RexNode toRex(SqlRexContext rexContext) {
        FlinkCalciteSqlValidator validator = (FlinkCalciteSqlValidator)rexContext.getValidator();
        RelOptCluster cluster = validator.getRelOptCluster();
        FlinkContext context = ShortcutUtils.unwrapContext(cluster);
        ModelProvider modelProvider = this.createModelProvider(context, this.contextResolvedModel);
        return new RexModelCall(this.getInputRowType(validator.getTypeFactory()), this.contextResolvedModel, modelProvider);
    }

    private static RelDataType schemaToRelDataType(FlinkTypeFactory typeFactory, ResolvedSchema schema) {
        List fieldNames = schema.getColumnNames();
        List<LogicalType> fieldTypes = schema.getColumnDataTypes().stream().map(DataType::getLogicalType).map(PlannerTypeUtils::removeLegacyTypes).collect(Collectors.toList());
        return typeFactory.buildRelNodeRowType(fieldNames, fieldTypes);
    }

    private ModelProvider createModelProvider(FlinkContext context, ContextResolvedModel catalogModel) {
        Optional<ModelProviderFactory> factoryFromCatalog = catalogModel.getCatalog().flatMap(Catalog::getFactory).map(f -> f instanceof ModelProviderFactory ? (ModelProviderFactory)f : null);
        Optional factoryFromModule = context.getModuleManager().getFactory(Module::getModelProviderFactory);
        ModelProviderFactory factory = OptionalUtils.firstPresent((Optional[])new Optional[]{factoryFromCatalog, factoryFromModule}).orElse(null);
        return FactoryUtil.createModelProvider((ModelProviderFactory)factory, (ObjectIdentifier)this.contextResolvedModel.getIdentifier(), (ResolvedCatalogModel)this.contextResolvedModel.getResolvedModel(), (ReadableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), (boolean)this.contextResolvedModel.isTemporary());
    }
}

