/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCallCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.functions.inference.FunctionCallContext;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.RexLiteralUtil;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Function1;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;

public final class FunctionCallCodeGenerator$ {
    public static FunctionCallCodeGenerator$ MODULE$;

    static {
        new FunctionCallCodeGenerator$();
    }

    public FunctionCallCodeGenerator.GeneratedTableFunctionWithDataType<FlatMapFunction<RowData, RowData>> generateSyncFunctionCall(ReadableConfig tableConfig, ClassLoader classLoader, DataTypeFactory dataTypeFactory, LogicalType inputType, LogicalType functionOutputType, LogicalType collectorOutputType, List<FunctionCallUtil.FunctionParam> parameters, TableFunction<?> syncFunctionDefinition, Function4<CodeGeneratorContext, FunctionCallContext, UserDefinedFunction, Seq<GeneratedExpression>, scala.Tuple2<GeneratedExpression, DataType>> inferCall, String functionName, String generateClassName, boolean fieldCopy) {
        Function1 & Serializable & scala.Serializable bodyCode = (Function1 & Serializable & scala.Serializable)call -> {
            String resultCollectorTerm = call.resultTerm();
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n         |").append(resultCollectorTerm).append(".setCollector(").append(CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM()).append(");\n         |").append(call.code()).append("\n         |").toString())).stripMargin();
        };
        return this.generateFunctionCall((Class)FlatMapFunction.class, tableConfig, classLoader, dataTypeFactory, inputType, functionOutputType, collectorOutputType, parameters, (UserDefinedFunction)syncFunctionDefinition, inferCall, functionName, generateClassName, fieldCopy, (Function1<GeneratedExpression, String>)bodyCode);
    }

    public FunctionCallCodeGenerator.GeneratedTableFunctionWithDataType<AsyncFunction<RowData, Object>> generateAsyncFunctionCall(ReadableConfig tableConfig, ClassLoader classLoader, DataTypeFactory dataTypeFactory, LogicalType inputType, LogicalType functionOutputType, LogicalType collectorOutputType, List<FunctionCallUtil.FunctionParam> parameters, AsyncTableFunction<?> asyncFunctionDefinition, Function4<CodeGeneratorContext, FunctionCallContext, UserDefinedFunction, Seq<GeneratedExpression>, scala.Tuple2<GeneratedExpression, DataType>> generateCallWithDataType, String functionName, String generateClassName) {
        return this.generateFunctionCall((Class)AsyncFunction.class, tableConfig, classLoader, dataTypeFactory, inputType, functionOutputType, collectorOutputType, parameters, (UserDefinedFunction)asyncFunctionDefinition, generateCallWithDataType, functionName, generateClassName, true, (Function1<GeneratedExpression, String>)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.code());
    }

    private <F extends Function> FunctionCallCodeGenerator.GeneratedTableFunctionWithDataType<F> generateFunctionCall(Class<F> generatedClass, ReadableConfig tableConfig, ClassLoader classLoader, DataTypeFactory dataTypeFactory, LogicalType inputType, LogicalType functionOutputType, LogicalType collectorOutputType, List<FunctionCallUtil.FunctionParam> parameters, UserDefinedFunction functionDefinition, Function4<CodeGeneratorContext, FunctionCallContext, UserDefinedFunction, Seq<GeneratedExpression>, scala.Tuple2<GeneratedExpression, DataType>> generateCallWithDataType, String functionName, String generateClassName, boolean fieldCopy, Function1<GeneratedExpression, String> bodyCode) {
        FunctionCallContext callContext = new FunctionCallContext(dataTypeFactory, functionDefinition, inputType, parameters, functionOutputType);
        UserDefinedFunction udf = UserDefinedFunctionHelper.createSpecializedFunction((String)functionName, (FunctionDefinition)functionDefinition, (CallContext)callContext, (ClassLoader)PlannerBase.class.getClassLoader(), (ReadableConfig)tableConfig, null);
        CodeGeneratorContext ctx = new CodeGeneratorContext(tableConfig, classLoader);
        Seq<GeneratedExpression> operands = this.prepareOperands(ctx, inputType, parameters, fieldCopy);
        scala.Tuple2 callWithDataType = (scala.Tuple2)generateCallWithDataType.apply((Object)ctx, (Object)callContext, (Object)udf, operands);
        GeneratedFunction<F> function = FunctionCodeGenerator$.MODULE$.generateFunction(ctx, generateClassName, generatedClass, (String)bodyCode.apply(callWithDataType._1()), collectorOutputType, inputType, FunctionCodeGenerator$.MODULE$.generateFunction$default$7(), FunctionCodeGenerator$.MODULE$.generateFunction$default$8(), FunctionCodeGenerator$.MODULE$.generateFunction$default$9(), FunctionCodeGenerator$.MODULE$.generateFunction$default$10(), FunctionCodeGenerator$.MODULE$.generateFunction$default$11());
        return new FunctionCallCodeGenerator.GeneratedTableFunctionWithDataType<F>(function, (DataType)callWithDataType._2());
    }

    private Seq<GeneratedExpression> prepareOperands(CodeGeneratorContext ctx, LogicalType inputType, List<FunctionCallUtil.FunctionParam> parameters, boolean fieldCopy) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parameters).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FunctionCallUtil.FunctionParam functionParam = x0$1;
            if (functionParam instanceof FunctionCallUtil.Constant) {
                FunctionCallUtil.Constant constant = (FunctionCallUtil.Constant)functionParam;
                Tuple2<Object, LogicalType> res = RexLiteralUtil.toFlinkInternalValue(constant.literal);
                return GenerateUtils$.MODULE$.generateLiteral(ctx, res.f0, (LogicalType)res.f1);
            }
            if (functionParam instanceof FunctionCallUtil.FieldRef) {
                FunctionCallUtil.FieldRef fieldRef = (FunctionCallUtil.FieldRef)functionParam;
                return GenerateUtils$.MODULE$.generateInputAccess(ctx, inputType, CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM(), fieldRef.index, false, fieldCopy);
            }
            throw new CodeGenException("Invalid parameters.");
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public GeneratedCollector<ListenableCollector<RowData>> generateCollector(CodeGeneratorContext ctx, RowType inputRowType, RowType rightRowType, RowType resultRowType, Option<RexNode> condition, Option<int[]> pojoFieldMapping, boolean retainHeader) {
        String string;
        String inputTerm = CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
        String rightInputTerm = CodeGenUtils$.MODULE$.DEFAULT_INPUT2_TERM();
        ExprCodeGenerator exprGenerator = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)rightRowType, rightInputTerm, pojoFieldMapping);
        GeneratedExpression rightResultExpr = exprGenerator.generateConverterResultExpression(rightRowType, GenericRowData.class, exprGenerator.generateConverterResultExpression$default$3(), exprGenerator.generateConverterResultExpression$default$4(), exprGenerator.generateConverterResultExpression$default$5(), exprGenerator.generateConverterResultExpression$default$6(), exprGenerator.generateConverterResultExpression$default$7());
        String joinedRowTerm = CodeGenUtils$.MODULE$.newName(ctx, "joinedRow");
        ctx.addReusableOutputRecord((LogicalType)resultRowType, JoinedRowData.class, joinedRowTerm, ctx.addReusableOutputRecord$default$4());
        String header = retainHeader ? new StringBuilder(27).append(joinedRowTerm).append(".setRowKind(").append(inputTerm).append(".getRowKind());").toString() : "";
        String body = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |").append(rightResultExpr.code()).append("\n         |").append(joinedRowTerm).append(".replace(").append(inputTerm).append(", ").append(rightResultExpr.resultTerm()).append(");\n         |").append(header).append("\n         |outputResult(").append(joinedRowTerm).append(");\n      ").toString())).stripMargin();
        if (condition.isEmpty()) {
            string = body;
        } else {
            ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
            RowType x$1 = inputRowType;
            String x$2 = inputTerm;
            Option<int[]> x$3 = qual$1.bindInput$default$3();
            ExprCodeGenerator filterGenerator = qual$1.bindInput((LogicalType)x$1, x$2, x$3).bindSecondInput((LogicalType)rightRowType, rightInputTerm, pojoFieldMapping);
            GeneratedExpression filterCondition = filterGenerator.generateExpression((RexNode)condition.get());
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n         |").append(filterCondition.code()).append("\n         |if (").append(filterCondition.resultTerm()).append(") {\n         |  ").append(body).append("\n         |}\n         |").toString())).stripMargin();
        }
        String collectorCode = string;
        return this.generateTableFunctionCollectorForJoinTable(ctx, "JoinTableFuncCollector", collectorCode, inputRowType, rightRowType, inputTerm, rightInputTerm);
    }

    public boolean generateCollector$default$7() {
        return true;
    }

    private GeneratedCollector<ListenableCollector<RowData>> generateTableFunctionCollectorForJoinTable(CodeGeneratorContext ctx, String name, String bodyCode, RowType inputType, RowType collectedType, String inputTerm, String collectedTerm) {
        String funcName = CodeGenUtils$.MODULE$.newName(ctx, name);
        String input1TypeClass = CodeGenUtils$.MODULE$.boxedTypeTermForType((LogicalType)inputType);
        String input2TypeClass = CodeGenUtils$.MODULE$.boxedTypeTermForType((LogicalType)collectedType);
        String funcCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(935).append("\n      public class ").append(funcName).append(" extends ").append(ListenableCollector.class.getCanonicalName()).append(" {\n\n        ").append(ctx.reuseMemberCode()).append("\n\n        public ").append(funcName).append("(Object[] references) throws Exception {\n          ").append(ctx.reuseInitCode()).append("\n        }\n\n        @Override\n        public void open(").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(OpenContext.class))).append(" openContext) throws Exception {\n          ").append(ctx.reuseOpenCode()).append("\n        }\n\n        @Override\n        public void collect(Object record) throws Exception {\n          ").append(input1TypeClass).append(" ").append(inputTerm).append(" = (").append(input1TypeClass).append(") getInput();\n          ").append(input2TypeClass).append(" ").append(collectedTerm).append(" = (").append(input2TypeClass).append(") record;\n\n          // callback only when collectListener exists, equivalent to:\n          // getCollectListener().ifPresent(\n          //   listener -> ((CollectListener) listener).onCollect(record));\n          // TODO we should update code splitter's grammar file to accept lambda expressions.\n\n          if (getCollectListener().isPresent()) {\n             ((").append(ListenableCollector.CollectListener.class.getCanonicalName()).append(") getCollectListener().get())\n             .onCollect(record);\n          }\n\n          ").append(ctx.reuseLocalVariableCode(ctx.reuseLocalVariableCode$default$1())).append("\n          ").append(ctx.reuseInputUnboxingCode()).append("\n          ").append(ctx.reusePerRecordCode()).append("\n          ").append(bodyCode).append("\n        }\n\n        @Override\n        public void close() throws Exception {\n          ").append(ctx.reuseCloseCode()).append("\n        }\n      }\n    ").toString())).stripMargin();
        return new GeneratedCollector(funcName, funcCode, (Object[])ctx.references().toArray(ClassTag$.MODULE$.AnyRef()), ctx.tableConfig());
    }

    private String generateTableFunctionCollectorForJoinTable$default$6() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
    }

    private String generateTableFunctionCollectorForJoinTable$default$7() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT2_TERM();
    }

    private FunctionCallCodeGenerator$() {
        MODULE$ = this;
    }
}

