/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import org.apache.flink.sql.parser.ddl.SqlAlterViewProperties;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterViewPropertiesOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConvertUtils;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlAlterViewPropertiesConverter
implements SqlNodeConverter<SqlAlterViewProperties> {
    @Override
    public Operation convertSqlNode(SqlAlterViewProperties alterView, SqlNodeConverter.ConvertContext context) {
        CatalogView oldView = SqlNodeConvertUtils.validateAlterView(alterView, context);
        ObjectIdentifier viewIdentifier = context.getCatalogManager().qualifyIdentifier(UnresolvedIdentifier.of((String[])alterView.fullViewName()));
        HashMap<String, String> newOptions = new HashMap<String, String>(oldView.getOptions());
        newOptions.putAll(OperationConverterUtils.getProperties(alterView.getPropertyList()));
        CatalogView newView = CatalogView.of((Schema)oldView.getUnresolvedSchema(), (String)oldView.getComment(), (String)oldView.getOriginalQuery(), (String)oldView.getExpandedQuery(), newOptions);
        return new AlterViewPropertiesOperation(viewIdentifier, newView);
    }
}

