/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlAlterTableSchema;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.NopOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterTableChangeOperation;
import org.apache.flink.table.operations.utils.ValidationUtils;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public abstract class AbstractAlterTableConverter<T extends SqlAlterTable>
implements SqlNodeConverter<T> {
    protected static final String EX_MSG_PREFIX = "Failed to execute ALTER TABLE statement.\n";

    protected abstract Operation convertToOperation(T var1, ResolvedCatalogTable var2, SqlNodeConverter.ConvertContext var3);

    protected final Schema getOldSchema(ResolvedCatalogTable resolvedCatalogTable) {
        return resolvedCatalogTable.getUnresolvedSchema();
    }

    protected final TableDistribution getOldTableDistribution(ResolvedCatalogTable resolvedCatalogTable) {
        return resolvedCatalogTable.getDistribution().orElse(null);
    }

    protected final List<String> getOldPartitionKeys(ResolvedCatalogTable resolvedCatalogTable) {
        return resolvedCatalogTable.getPartitionKeys();
    }

    protected final String getOldComment(ResolvedCatalogTable resolvedCatalogTable) {
        return resolvedCatalogTable.getComment();
    }

    protected final Map<String, String> getOldOptions(ResolvedCatalogTable resolvedCatalogTable) {
        return resolvedCatalogTable.getOptions();
    }

    @Override
    public final Operation convertSqlNode(T sqlAlterTable, SqlNodeConverter.ConvertContext context) {
        ObjectIdentifier tableIdentifier;
        CatalogManager catalogManager = context.getCatalogManager();
        Optional optionalCatalogTable = catalogManager.getTable(tableIdentifier = this.getIdentifier((SqlAlterTable)sqlAlterTable, context));
        if (optionalCatalogTable.isEmpty() || ((ContextResolvedTable)optionalCatalogTable.get()).isTemporary()) {
            if (((SqlAlterTable)sqlAlterTable).ifTableExists()) {
                return new NopOperation();
            }
            throw new ValidationException(String.format("Table %s doesn't exist or is a temporary table.", tableIdentifier));
        }
        ValidationUtils.validateTableKind((CatalogBaseTable)((ContextResolvedTable)optionalCatalogTable.get()).getTable(), (CatalogBaseTable.TableKind)CatalogBaseTable.TableKind.TABLE, (String)"alter table");
        return this.convertToOperation(sqlAlterTable, (ResolvedCatalogTable)((ContextResolvedTable)optionalCatalogTable.get()).getResolvedTable(), context);
    }

    protected final Operation buildAlterTableChangeOperation(SqlAlterTable alterTable, List<TableChange> tableChanges, Schema newSchema, ResolvedCatalogTable oldTable, CatalogManager catalogManager) {
        TableDistribution tableDistribution = this.getTableDistribution(alterTable, oldTable);
        CatalogTable.Builder builder = CatalogTable.newBuilder().schema(newSchema).comment(oldTable.getComment()).partitionKeys(oldTable.getPartitionKeys()).distribution(tableDistribution).options(oldTable.getOptions());
        oldTable.getSnapshot().ifPresent(arg_0 -> ((CatalogTable.Builder)builder).snapshot(arg_0));
        return new AlterTableChangeOperation(catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])alterTable.fullTableName())), tableChanges, builder.build(), alterTable.ifTableExists());
    }

    protected static String getColumnName(SqlIdentifier identifier) {
        if (!identifier.isSimple()) {
            throw new UnsupportedOperationException(String.format("%sAlter nested row type %s is not supported yet.", EX_MSG_PREFIX, identifier));
        }
        return identifier.getSimple();
    }

    protected final ObjectIdentifier getIdentifier(SqlAlterTable node, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])node.fullTableName());
        return context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
    }

    protected TableDistribution getTableDistribution(SqlAlterTable alterTable, ResolvedCatalogTable oldTable) {
        Optional<TableDistribution> tableDistribution;
        if (alterTable instanceof SqlAlterTableSchema && (tableDistribution = ((SqlAlterTableSchema)alterTable).getDistribution().map(OperationConverterUtils::getDistributionFromSqlDistribution)).isPresent()) {
            return tableDistribution.get();
        }
        return oldTable.getDistribution().orElse(null);
    }
}

