/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.List;
import java.util.function.Function;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropWatermark;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SchemaReferencesManager;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;

public class SqlAlterTableDropWatermarkConverter
extends AbstractAlterTableConverter<SqlAlterTableDropWatermark> {
    @Override
    protected Operation convertToOperation(SqlAlterTableDropWatermark dropWatermark, ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        if (oldTable.getResolvedSchema().getWatermarkSpecs().isEmpty()) {
            throw new ValidationException(String.format("%sThe base table does not define any watermark strategy.", "Failed to execute ALTER TABLE statement.\n"));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        SchemaReferencesManager.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> builder.fromColumns(List.of(column)));
        SchemaReferencesManager.buildUpdatedPrimaryKey(schemaBuilder, oldTable, Function.identity());
        return this.buildAlterTableChangeOperation(dropWatermark, List.of(TableChange.dropWatermark()), schemaBuilder.build(), oldTable, context.getCatalogManager());
    }
}

