/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlCreateTableAs;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.operations.CreateTableASOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractCreateTableConverter;
import org.apache.flink.table.planner.operations.converters.table.MergeTableAsUtil;

public class SqlCreateTableAsConverter
extends AbstractCreateTableConverter<SqlCreateTableAs> {
    @Override
    public Operation convertSqlNode(SqlCreateTableAs sqlCreateTableAs, SqlNodeConverter.ConvertContext context) {
        FlinkPlannerImpl flinkPlanner = context.getFlinkPlanner();
        CatalogManager catalogManager = context.getCatalogManager();
        SqlNode asQuerySqlNode = sqlCreateTableAs.getAsQuery();
        SqlNode validatedAsQuery = flinkPlanner.validate(asQuerySqlNode);
        PlannerQueryOperation query = (PlannerQueryOperation)SqlNodeToOperationConversion.convert(flinkPlanner, catalogManager, validatedAsQuery).orElseThrow(() -> new TableException("CTAS unsupported node type " + validatedAsQuery.getClass().getSimpleName()));
        ResolvedCatalogTable tableWithResolvedSchema = this.getResolvedCatalogTable(sqlCreateTableAs, context, query.getResolvedSchema());
        query = new MergeTableAsUtil(context).maybeRewriteQuery(catalogManager, flinkPlanner, query, validatedAsQuery, tableWithResolvedSchema);
        ObjectIdentifier identifier = this.getIdentifier(sqlCreateTableAs, context);
        CreateTableOperation createTableOperation = this.getCreateTableOperation(identifier, tableWithResolvedSchema, sqlCreateTableAs);
        return new CreateTableASOperation(createTableOperation, Map.of(), (QueryOperation)query, false);
    }

    @Override
    protected AbstractCreateTableConverter.MergeContext getMergeContext(final SqlCreateTableAs sqlCreateTableAs, final SqlNodeConverter.ConvertContext context) {
        return new AbstractCreateTableConverter.MergeContext(){
            private final MergeTableAsUtil mergeTableAsUtil;
            {
                this.mergeTableAsUtil = new MergeTableAsUtil(context);
            }

            @Override
            public Schema getMergedSchema(ResolvedSchema schemaToMerge) {
                if (sqlCreateTableAs.isSchemaWithColumnsIdentifiersOnly()) {
                    return this.mergeTableAsUtil.reorderSchema(sqlCreateTableAs.getColumnList(), schemaToMerge);
                }
                return this.mergeTableAsUtil.mergeSchemas(sqlCreateTableAs.getColumnList(), sqlCreateTableAs.getWatermark().orElse(null), sqlCreateTableAs.getFullConstraints(), schemaToMerge);
            }

            @Override
            public Map<String, String> getMergedTableOptions() {
                return SqlCreateTableAsConverter.this.getDerivedTableOptions(sqlCreateTableAs);
            }

            @Override
            public List<String> getMergedPartitionKeys() {
                return SqlCreateTableAsConverter.this.getDerivedPartitionKeys(sqlCreateTableAs);
            }

            @Override
            public Optional<TableDistribution> getMergedTableDistribution() {
                return SqlCreateTableAsConverter.this.getDerivedTableDistribution(sqlCreateTableAs);
            }
        };
    }
}

