/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractCreateTableConverter;
import org.apache.flink.table.planner.operations.converters.table.MergeTableLikeUtil;

public class SqlCreateTableConverter
extends AbstractCreateTableConverter<SqlCreateTable> {
    @Override
    public Operation convertSqlNode(SqlCreateTable sqlCreateTable, SqlNodeConverter.ConvertContext context) {
        ResolvedCatalogTable catalogTable = this.getResolvedCatalogTable(sqlCreateTable, context, null);
        ObjectIdentifier identifier = this.getIdentifier(sqlCreateTable, context);
        return this.getCreateTableOperation(identifier, catalogTable, sqlCreateTable);
    }

    @Override
    protected AbstractCreateTableConverter.MergeContext getMergeContext(final SqlCreateTable sqlCreateTable, final SqlNodeConverter.ConvertContext context) {
        return new AbstractCreateTableConverter.MergeContext(){
            private final MergeTableLikeUtil mergeTableLikeUtil;
            {
                this.mergeTableLikeUtil = new MergeTableLikeUtil(context);
            }

            @Override
            public Schema getMergedSchema(ResolvedSchema schemaToMerge) {
                Optional<SqlTableConstraint> tableConstraint = sqlCreateTable.getFullConstraints().stream().filter(SqlTableConstraint::isPrimaryKey).findAny();
                return this.mergeTableLikeUtil.mergeTables(Map.of(), Schema.newBuilder().build(), sqlCreateTable.getColumnList().getList(), sqlCreateTable.getWatermark().map(Collections::singletonList).orElseGet(Collections::emptyList), tableConstraint.orElse(null));
            }

            @Override
            public Map<String, String> getMergedTableOptions() {
                return SqlCreateTableConverter.this.getDerivedTableOptions(sqlCreateTable);
            }

            @Override
            public List<String> getMergedPartitionKeys() {
                return SqlCreateTableConverter.this.getDerivedPartitionKeys(sqlCreateTable);
            }

            @Override
            public Optional<TableDistribution> getMergedTableDistribution() {
                return SqlCreateTableConverter.this.getDerivedTableDistribution(sqlCreateTable);
            }
        };
    }
}

