/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.sink;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsTargetColumnWriting;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="TargetColumnWriting")
public class TargetColumnWritingSpec
implements SinkAbilitySpec {
    public static final String FIELD_NAME_TARGET_COLUMNS = "targetColumns";
    @JsonProperty(value="targetColumns")
    private final int[][] targetColumns;

    @JsonCreator
    public TargetColumnWritingSpec(@JsonProperty(value="targetColumns") int[][] targetColumns) {
        this.targetColumns = targetColumns;
    }

    @Override
    public void apply(DynamicTableSink tableSink) {
        if (!(tableSink instanceof SupportsTargetColumnWriting)) {
            throw new TableException(String.format("%s does not support SupportsTargetColumnWriting.", tableSink.getClass().getName()));
        }
        ((SupportsTargetColumnWriting)tableSink).applyTargetColumns(this.targetColumns);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetColumnWritingSpec that = (TargetColumnWritingSpec)o;
        return Objects.deepEquals(this.targetColumns, that.targetColumns);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.targetColumns);
    }
}

