/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGeneratorSupplier;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.watermark.WatermarkEmitStrategy;
import org.apache.flink.table.watermark.WatermarkParams;
import org.apache.flink.util.Preconditions;
import scala.Option;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="WatermarkPushDown")
public final class WatermarkPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_WATERMARK_EXPR = "watermarkExpr";
    public static final String FIELD_NAME_ROWTIME_EXPR = "rowtimeExpr";
    public static final String FIELD_NAME_GLOBAL_IDLE_TIMEOUT_MILLIS = "idleTimeoutMillis";
    public static final String FIELD_NAME_WATERMARK_PARAMS = "watermarkParams";
    @JsonProperty(value="watermarkExpr")
    private final RexNode watermarkExpr;
    @Nullable
    @JsonProperty(value="rowtimeExpr")
    private final RexNode rowtimeExpr;
    @JsonProperty(value="idleTimeoutMillis")
    private final long globalIdleTimeoutMillis;
    @Nullable
    @JsonProperty(value="watermarkParams")
    private final WatermarkParams watermarkParams;

    @JsonCreator
    public WatermarkPushDownSpec(@JsonProperty(value="watermarkExpr") RexNode watermarkExpr, @Nullable @JsonProperty(value="rowtimeExpr") RexNode rowtimeExpr, @JsonProperty(value="idleTimeoutMillis") long globalIdleTimeoutMillis, @JsonProperty(value="producedType") RowType producedType, @JsonProperty(value="watermarkParams") WatermarkParams watermarkParams) {
        super(producedType);
        this.watermarkExpr = (RexNode)Preconditions.checkNotNull((Object)watermarkExpr);
        this.rowtimeExpr = rowtimeExpr;
        this.globalIdleTimeoutMillis = globalIdleTimeoutMillis;
        this.watermarkParams = watermarkParams;
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        WatermarkStrategy watermarkStrategy;
        if (tableSource instanceof SupportsWatermarkPushDown) {
            long actualIdleTimeoutMillis;
            GeneratedWatermarkGenerator generatedWatermarkGenerator = WatermarkGeneratorCodeGenerator.generateWatermarkGenerator((ReadableConfig)context.getTableConfig(), context.getClassLoader(), context.getSourceRowType(), this.watermarkExpr, (Option<RexNode>)(this.rowtimeExpr != null ? Option.apply((Object)this.rowtimeExpr) : Option.empty()), (Option<String>)Option.apply((Object)"context"));
            GeneratedWatermarkGeneratorSupplier supplier = new GeneratedWatermarkGeneratorSupplier(generatedWatermarkGenerator, this.watermarkParams);
            watermarkStrategy = WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier)supplier);
            if (this.watermarkParams != null && this.watermarkParams.alignWatermarkEnabled()) {
                watermarkStrategy = watermarkStrategy.withWatermarkAlignment(this.watermarkParams.getAlignGroupName(), this.watermarkParams.getAlignMaxDrift(), this.watermarkParams.getAlignUpdateInterval());
            }
            if ((actualIdleTimeoutMillis = this.calculateIdleTimeoutMillis()) > 0L) {
                watermarkStrategy = watermarkStrategy.withIdleness(Duration.ofMillis(actualIdleTimeoutMillis));
            }
        } else {
            throw new TableException(String.format("%s does not support SupportsWatermarkPushDown.", tableSource.getClass().getName()));
        }
        ((SupportsWatermarkPushDown)tableSource).applyWatermark(watermarkStrategy);
    }

    @Override
    public boolean needAdjustFieldReferenceAfterProjection() {
        return true;
    }

    public WatermarkPushDownSpec copy(RexNode watermarkExpr, @Nullable RexNode rowtimeExpr, RowType producedType) {
        return new WatermarkPushDownSpec(watermarkExpr, rowtimeExpr, this.globalIdleTimeoutMillis, producedType, this.watermarkParams);
    }

    public RexNode getWatermarkExpr() {
        return this.watermarkExpr;
    }

    public Optional<RexNode> getRowtimeExpr() {
        return Optional.ofNullable(this.rowtimeExpr);
    }

    @Override
    public String getDigests(SourceAbilityContext context) {
        String expressionStr = FlinkRexUtil.getExpressionString(this.watermarkExpr, JavaScalaConversionUtil.toScala(context.getSourceRowType().getFieldNames()));
        StringBuilder sb = new StringBuilder();
        sb.append("watermark=[").append(expressionStr).append("]");
        long actualIdleTimeoutMillis = this.calculateIdleTimeoutMillis();
        if (actualIdleTimeoutMillis > 0L) {
            sb.append(", idletimeout=[").append(actualIdleTimeoutMillis).append("]");
        }
        if (this.watermarkParams != null) {
            WatermarkEmitStrategy emitStrategy = this.watermarkParams.getEmitStrategy();
            sb.append(", watermarkEmitStrategy=[").append(emitStrategy).append("]");
            if (this.watermarkParams.alignWatermarkEnabled()) {
                sb.append(", watermarkAlignment=[").append(this.watermarkParams.getAlignGroupName()).append(", ").append(this.watermarkParams.getAlignMaxDrift()).append(", ").append(this.watermarkParams.getAlignUpdateInterval()).append("]");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WatermarkPushDownSpec that = (WatermarkPushDownSpec)o;
        return this.globalIdleTimeoutMillis == that.globalIdleTimeoutMillis && Objects.equals(this.watermarkExpr, that.watermarkExpr) && Objects.equals(this.watermarkParams, that.watermarkParams);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.watermarkExpr, this.globalIdleTimeoutMillis, this.watermarkParams);
    }

    private long calculateIdleTimeoutMillis() {
        long actualIdleTimeoutMillis = this.globalIdleTimeoutMillis;
        if (this.watermarkParams != null && this.watermarkParams.getSourceIdleTimeout() >= 0L) {
            actualIdleTimeoutMillis = this.watermarkParams.getSourceIdleTimeout();
        }
        return actualIdleTimeoutMillis;
    }
}

