/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.async.AsyncWaitOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.AsyncCorrelateCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AsyncTableUtil;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.correlate.async.AsyncCorrelateRunner;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

public class CommonExecAsyncCorrelate
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String ASYNC_CORRELATE_TRANSFORMATION = "async-correlate";
    public static final String FIELD_NAME_JOIN_TYPE = "joinType";
    public static final String FIELD_NAME_FUNCTION_CALL = "functionCall";
    @JsonProperty(value="joinType")
    private final FlinkJoinType joinType;
    @JsonProperty(value="functionCall")
    private final RexCall invocation;

    public CommonExecAsyncCorrelate(int id, ExecNodeContext context, ReadableConfig persistedConfig, FlinkJoinType joinType, RexCall invocation, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.joinType = joinType;
        this.invocation = invocation;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        OneInputTransformation<RowData, RowData> transform = this.createAsyncOneInputTransformation(inputTransform, config, planner.getFlinkContext().getClassLoader());
        return transform;
    }

    private OneInputTransformation<RowData, RowData> createAsyncOneInputTransformation(Transformation<RowData> inputTransform, ExecNodeConfig config, ClassLoader classLoader) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        RowType inputRowType = RowType.of((LogicalType[])inputEdge.getOutputType().getChildren().toArray(new LogicalType[0]));
        InternalTypeInfo asyncOperatorResultTypeInfo = InternalTypeInfo.of((LogicalType)this.getOutputType());
        OneInputStreamOperatorFactory<RowData, RowData> factory = this.getAsyncFunctionOperator(config, classLoader, inputRowType);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(ASYNC_CORRELATE_TRANSFORMATION, config), factory, asyncOperatorResultTypeInfo, inputTransform.getParallelism(), false);
    }

    private OneInputStreamOperatorFactory<RowData, RowData> getAsyncFunctionOperator(ExecNodeConfig config, ClassLoader classLoader, RowType inputRowType) {
        RowType resultTypeInfo = (RowType)FlinkTypeFactory.toLogicalType(this.invocation.getType());
        GeneratedFunction<AsyncFunction<RowData, Object>> generatedFunction = AsyncCorrelateCodeGenerator.generateFunction("AsyncTableFunction", inputRowType, resultTypeInfo, this.invocation, config, classLoader);
        DataStructureConverter<RowData, Object> fetcherConverter = this.cast((DataStructureConverter<Object, Object>)DataStructureConverters.getConverter((DataType)TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(this.invocation.getType()))));
        AsyncCorrelateRunner func = new AsyncCorrelateRunner(generatedFunction, fetcherConverter);
        FunctionCallUtil.AsyncOptions options = AsyncTableUtil.getAsyncOptions(config);
        return new AsyncWaitOperatorFactory((AsyncFunction)func, options.asyncTimeout, options.asyncBufferCapacity, options.asyncOutputMode, AsyncTableUtil.getResultRetryStrategy(config));
    }

    private DataStructureConverter<RowData, Object> cast(DataStructureConverter<Object, Object> converter) {
        return converter;
    }
}

