/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;

@Internal
final class ShuffleJsonSerializer
extends StdSerializer<ExecEdge.Shuffle> {
    private static final long serialVersionUID = 1L;

    ShuffleJsonSerializer() {
        super(ExecEdge.Shuffle.class);
    }

    public void serialize(ExecEdge.Shuffle shuffle, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        ExecEdge.Shuffle.Type type = shuffle.getType();
        jsonGenerator.writeStringField("type", type.name());
        switch (type) {
            case ANY: 
            case SINGLETON: 
            case BROADCAST: 
            case FORWARD: {
                break;
            }
            case HASH: {
                ExecEdge.HashShuffle hashShuffle = (ExecEdge.HashShuffle)shuffle;
                jsonGenerator.writeFieldName("keys");
                jsonGenerator.writeArray(hashShuffle.getKeys(), 0, hashShuffle.getKeys().length);
                break;
            }
            default: {
                throw new TableException("Unsupported shuffle type: " + String.valueOf((Object)type));
            }
        }
        jsonGenerator.writeEndObject();
    }
}

