/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CompiledPlanSerdeUtil;

@Internal
final class TableDistributionJsonDeserializer
extends StdDeserializer<TableDistribution> {
    private static final long serialVersionUID = 1L;

    TableDistributionJsonDeserializer() {
        super(TableDistribution.class);
    }

    public TableDistribution deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        if (!(jsonNode instanceof ObjectNode)) {
            return null;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        ObjectCodec codec = jsonParser.getCodec();
        TableDistribution.Kind kind = (TableDistribution.Kind)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)jsonNode.required("kind"), codec), TableDistribution.Kind.class);
        Integer bucketCount = CompiledPlanSerdeUtil.deserializeFieldOrNull(objectNode, "bucketCount", Integer.class, codec, ctx);
        List<String> bucketKeys = CompiledPlanSerdeUtil.deserializeList(objectNode, "bucketKeys", String.class, codec, ctx);
        return TableDistribution.of((TableDistribution.Kind)kind, (Integer)bucketCount, bucketKeys);
    }
}

