/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Optional;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ModelProviderFactory;
import org.apache.flink.table.ml.ModelProvider;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.util.OptionalUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ModelSpec {
    public static final String FIELD_NAME_CATALOG_MODEL = "model";
    private final ContextResolvedModel contextResolvedModel;
    private ModelProvider provider;

    @JsonCreator
    public ModelSpec(@JsonProperty(value="model") ContextResolvedModel contextResolvedModel) {
        this.contextResolvedModel = contextResolvedModel;
    }

    @JsonGetter(value="model")
    public ContextResolvedModel getContextResolvedModel() {
        return this.contextResolvedModel;
    }

    public void setModelProvider(ModelProvider provider) {
        this.provider = provider;
    }

    public ModelProvider getModelProvider(FlinkContext context) {
        if (this.provider == null) {
            Optional<ModelProviderFactory> factoryFromCatalog = this.contextResolvedModel.getCatalog().flatMap(Catalog::getFactory).map(f -> f instanceof ModelProviderFactory ? (ModelProviderFactory)f : null);
            Optional factoryFromModule = context.getModuleManager().getFactory(Module::getModelProviderFactory);
            ModelProviderFactory factory = OptionalUtils.firstPresent((Optional[])new Optional[]{factoryFromCatalog, factoryFromModule}).orElse(null);
            this.provider = FactoryUtil.createModelProvider((ModelProviderFactory)factory, (ObjectIdentifier)this.contextResolvedModel.getIdentifier(), (ResolvedCatalogModel)this.contextResolvedModel.getResolvedModel(), (ReadableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), (boolean)this.contextResolvedModel.isTemporary());
        }
        return this.provider;
    }
}

