/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import java.util.function.Predicate;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.functions.async.AsyncRetryStrategy;
import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.runtime.operators.calc.async.RetryPredicates;

public class AsyncScalarUtil
extends FunctionCallUtil {
    public static FunctionCallUtil.AsyncOptions getAsyncOptions(ExecNodeConfig config) {
        return new FunctionCallUtil.AsyncOptions((Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_MAX_CONCURRENT_OPERATIONS), ((Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_TIMEOUT)).toMillis(), false, AsyncDataStream.OutputMode.ORDERED);
    }

    public static AsyncRetryStrategy<RowData> getResultRetryStrategy(ExecNodeConfig config) {
        ExecutionConfigOptions.RetryStrategy retryStrategy = (ExecutionConfigOptions.RetryStrategy)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_RETRY_STRATEGY);
        Duration retryDelay = (Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_RETRY_DELAY);
        int retryMaxAttempts = (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_MAX_ATTEMPTS);
        if (retryStrategy == ExecutionConfigOptions.RetryStrategy.FIXED_DELAY) {
            return new AsyncRetryStrategies.FixedDelayRetryStrategyBuilder(retryMaxAttempts, retryDelay.toMillis()).ifResult((Predicate)RetryPredicates.EMPTY_RESPONSE).ifException(RetryPredicates.ANY_EXCEPTION).build();
        }
        return AsyncRetryStrategies.NO_RETRY_STRATEGY;
    }
}

