/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCallFinder;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.util.Preconditions;

public class AsyncUtil {
    public static boolean containsAsyncCall(RexNode node, FunctionKind functionKind) {
        Preconditions.checkArgument((functionKind == FunctionKind.ASYNC_SCALAR || functionKind == FunctionKind.ASYNC_TABLE ? 1 : 0) != 0);
        return node.accept(new FunctionFinder(true, true, functionKind));
    }

    public static boolean containsAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(true, true, null));
    }

    public static boolean containsNonAsyncCall(RexNode node, FunctionKind functionKind) {
        Preconditions.checkArgument((functionKind == FunctionKind.ASYNC_SCALAR || functionKind == FunctionKind.ASYNC_TABLE ? 1 : 0) != 0);
        return node.accept(new FunctionFinder(false, true, functionKind));
    }

    public static boolean containsNonAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(false, true, null));
    }

    public static boolean isAsyncCall(RexNode node, FunctionKind functionKind) {
        Preconditions.checkArgument((functionKind == FunctionKind.ASYNC_SCALAR || functionKind == FunctionKind.ASYNC_TABLE ? 1 : 0) != 0);
        return node.accept(new FunctionFinder(true, false, functionKind));
    }

    public static boolean isAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(true, false, null));
    }

    public static boolean isNonAsyncCall(RexNode node, FunctionKind functionKind) {
        Preconditions.checkArgument((functionKind == FunctionKind.ASYNC_SCALAR || functionKind == FunctionKind.ASYNC_TABLE ? 1 : 0) != 0);
        return node.accept(new FunctionFinder(false, false, functionKind));
    }

    public static boolean isNonAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(false, false, null));
    }

    public static class AsyncRemoteCallFinder
    implements RemoteCallFinder {
        private final FunctionKind functionKind;

        public AsyncRemoteCallFinder(FunctionKind functionKind) {
            this.functionKind = functionKind;
        }

        @Override
        public boolean containsRemoteCall(RexNode node) {
            return AsyncUtil.containsAsyncCall(node, this.functionKind);
        }

        @Override
        public boolean containsNonRemoteCall(RexNode node) {
            return AsyncUtil.containsNonAsyncCall(node, this.functionKind);
        }

        @Override
        public boolean isRemoteCall(RexNode node) {
            return AsyncUtil.isAsyncCall(node, this.functionKind);
        }

        @Override
        public boolean isNonRemoteCall(RexNode node) {
            return AsyncUtil.isNonAsyncCall(node, this.functionKind);
        }

        @Override
        public String getName() {
            return "Async";
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this.functionKind == ((AsyncRemoteCallFinder)obj).functionKind;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class FunctionFinder
    extends RexDefaultVisitor<Boolean> {
        private final boolean findAsyncCall;
        private final boolean recursive;
        private final FunctionKind functionKind;

        public FunctionFinder(boolean findAsyncCall, boolean recursive, FunctionKind functionKind) {
            this.findAsyncCall = findAsyncCall;
            this.recursive = recursive;
            this.functionKind = functionKind;
        }

        @Override
        public Boolean visitNode(RexNode rexNode) {
            return false;
        }

        private boolean isImmediateAsyncCall(RexCall call) {
            FunctionDefinition definition = ShortcutUtils.unwrapFunctionDefinition(call);
            return definition != null && (this.functionKind != null && definition.getKind() == this.functionKind || this.functionKind == null && (definition.getKind() == FunctionKind.ASYNC_SCALAR || definition.getKind() == FunctionKind.ASYNC_TABLE));
        }

        @Override
        public Boolean visitCall(RexCall call) {
            boolean isImmediateAsyncCall = this.isImmediateAsyncCall(call);
            return this.findAsyncCall == isImmediateAsyncCall || this.recursive && call.getOperands().stream().anyMatch(node -> node.accept(this));
        }
    }
}

