/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.util.ratelimit.GuavaRateLimiter;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.datagen.source.DataGeneratorSource;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.functions.windowing.delta.DeltaFunction;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.evictors.TimeEvictor;
import org.apache.flink.streaming.api.windowing.triggers.DeltaTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.examples.windowing.util.CarGeneratorFunction;
import org.apache.flink.streaming.examples.wordcount.util.CLI;

public class TopSpeedWindowing {
    public static void main(String[] args) throws Exception {
        DataStreamSource carData;
        CLI params = CLI.fromArgs(args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setRuntimeMode(params.getExecutionMode());
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        if (params.getInputs().isPresent()) {
            FileSource.FileSourceBuilder builder = FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])params.getInputs().get());
            params.getDiscoveryInterval().ifPresent(x$0 -> {
                FileSource.FileSourceBuilder cfr_ignored_0 = (FileSource.FileSourceBuilder)builder.monitorContinuously(x$0);
            });
            carData = env.fromSource((Source)builder.build(), WatermarkStrategy.noWatermarks(), "file-input").map((MapFunction)new ParseCarData()).name("parse-input");
        } else {
            CarGeneratorFunction carGenerator = new CarGeneratorFunction(2);
            DataGeneratorSource<Tuple4<Integer, Integer, Double, Long>> carGeneratorSource = new DataGeneratorSource<Tuple4<Integer, Integer, Double, Long>>(carGenerator, Long.MAX_VALUE, (RateLimiterStrategy & Serializable)parallelismIgnored -> new GuavaRateLimiter(10.0), TypeInformation.of((TypeHint)new TypeHint<Tuple4<Integer, Integer, Double, Long>>(){}));
            carData = env.fromSource(carGeneratorSource, WatermarkStrategy.noWatermarks(), "Car data generator source");
            carData.setParallelism(1);
        }
        int evictionSec = 10;
        double triggerMeters = 50.0;
        KeyedStream keyedStream = carData.assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(car, ts) -> (Long)car.f3)).keyBy((KeySelector & Serializable)value -> (Integer)value.f0);
        if (params.isAsyncState()) {
            keyedStream = keyedStream.enableAsyncState();
        }
        SingleOutputStreamOperator topSpeeds = keyedStream.window((WindowAssigner)GlobalWindows.create()).evictor((Evictor)TimeEvictor.of((Duration)Duration.ofSeconds(evictionSec))).trigger((Trigger)DeltaTrigger.of((double)triggerMeters, (DeltaFunction)new DeltaFunction<Tuple4<Integer, Integer, Double, Long>>(){
            private static final long serialVersionUID = 1L;

            public double getDelta(Tuple4<Integer, Integer, Double, Long> oldDataPoint, Tuple4<Integer, Integer, Double, Long> newDataPoint) {
                return (Double)newDataPoint.f2 - (Double)oldDataPoint.f2;
            }
        }, (TypeSerializer)carData.getType().createSerializer(env.getConfig().getSerializerConfig()))).maxBy(1);
        if (params.getOutput().isPresent()) {
            topSpeeds.sinkTo((Sink)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)params.getOutput().get(), (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build())).build()).name("file-sink");
        } else {
            topSpeeds.print();
        }
        env.execute("CarTopSpeedWindowingExample");
    }

    private static class ParseCarData
    extends RichMapFunction<String, Tuple4<Integer, Integer, Double, Long>> {
        private static final long serialVersionUID = 1L;

        private ParseCarData() {
        }

        public Tuple4<Integer, Integer, Double, Long> map(String record) {
            String rawData = record.substring(1, record.length() - 1);
            String[] data = rawData.split(",");
            return new Tuple4((Object)Integer.valueOf(data[0]), (Object)Integer.valueOf(data[1]), (Object)Double.valueOf(data[2]), (Object)Long.valueOf(data[3]));
        }
    }
}

