/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.formats.common.Converter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonEncoding;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.jackson.JacksonMapperFactory;

class CsvBulkWriter<T, R, C>
implements BulkWriter<T> {
    private final FSDataOutputStream stream;
    private final Converter<T, R, C> converter;
    @Nullable
    private final C converterContext;
    private final JsonGenerator generator;

    CsvBulkWriter(CsvMapper mapper, CsvSchema schema, Converter<T, R, C> converter, @Nullable C converterContext, FSDataOutputStream stream) {
        Preconditions.checkNotNull((Object)mapper);
        Preconditions.checkNotNull((Object)schema);
        mapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        mapper.disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        this.converter = (Converter)Preconditions.checkNotNull(converter);
        this.stream = (FSDataOutputStream)Preconditions.checkNotNull((Object)stream);
        this.converterContext = converterContext;
        try {
            this.generator = mapper.writer((FormatSchema)schema).createGenerator((OutputStream)stream, JsonEncoding.UTF8);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not create CSV generator.", (Throwable)e);
        }
    }

    static <T, R, C> CsvBulkWriter<T, R, C> forSchema(CsvMapper mapper, CsvSchema schema, Converter<T, R, C> converter, @Nullable C converterContext, FSDataOutputStream stream) {
        return new CsvBulkWriter<T, R, C>(mapper, schema, converter, converterContext, stream);
    }

    static <T> CsvBulkWriter<T, T, Void> forPojo(Class<T> pojoClass, FSDataOutputStream stream) {
        Converter<Object, Object, Void> converter = (value, context) -> value;
        CsvMapper csvMapper = JacksonMapperFactory.createCsvMapper();
        CsvSchema schema = csvMapper.schemaFor(pojoClass).withoutQuoteChar();
        return new CsvBulkWriter<Object, Object, Object>(csvMapper, schema, converter, null, stream);
    }

    public void addElement(T element) throws IOException {
        R r = this.converter.convert(element, this.converterContext);
        this.generator.writeObject(r);
    }

    public void flush() throws IOException {
        this.generator.flush();
    }

    public void finish() throws IOException {
        this.generator.close();
        this.stream.sync();
    }
}

