/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;

@PublicEvolving
public final class OverWindow {
    private final Expression alias;
    private final List<Expression> partitioning;
    private final Expression order;
    @Nullable
    private final Expression preceding;
    @Nullable
    private final Expression following;

    OverWindow(Expression alias, List<Expression> partitionBy, Expression orderBy, @Nullable Expression preceding, @Nullable Expression following) {
        this.alias = alias;
        this.partitioning = partitionBy;
        this.order = orderBy;
        this.preceding = preceding;
        this.following = following;
    }

    public Expression getAlias() {
        return this.alias;
    }

    public List<Expression> getPartitioning() {
        return this.partitioning;
    }

    public Expression getOrder() {
        return this.order;
    }

    public Optional<Expression> getPreceding() {
        return Optional.ofNullable(this.preceding);
    }

    public Optional<Expression> getFollowing() {
        return Optional.ofNullable(this.following);
    }
}

