/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.state.v2.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.v2.internal.InternalValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.dataview.UnsupportedStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.WindowAggProcessorBase;
import org.apache.flink.table.runtime.operators.window.async.tvf.common.AsyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.async.tvf.state.WindowAsyncValueState;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.apache.flink.util.Preconditions;

public abstract class AbstractAsyncStateWindowAggProcessor<W>
extends WindowAggProcessorBase<W, AsyncStateWindowProcessor.AsyncStateContext<W>>
implements AsyncStateWindowProcessor<W> {
    private static final long serialVersionUID = 1L;
    protected final WindowIsEmptyChecker emptyChecker;
    private final W defaultWindow;
    protected transient WindowAsyncValueState<W> windowState;

    public AbstractAsyncStateWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<W> genAggsHandler, WindowAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, boolean isEventTime, int indexOfCountStar, ZoneId shiftTimeZone, W defaultWindow) {
        super(genAggsHandler, accSerializer, isEventTime, shiftTimeZone);
        this.emptyChecker = new WindowIsEmptyChecker(indexOfCountStar, sliceAssigner);
        this.defaultWindow = defaultWindow;
    }

    @Override
    public void open(AsyncStateWindowProcessor.AsyncStateContext<W> context) throws Exception {
        super.open(context);
        ValueState state = (ValueState)((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getAsyncKeyContext().getAsyncKeyedStateBackend().getOrCreateKeyedState(this.defaultWindow, this.createWindowSerializer(), (StateDescriptor)new ValueStateDescriptor("window-aggs", this.accSerializer));
        this.windowState = new WindowAsyncValueState((InternalValueState)state);
    }

    @Override
    protected final void prepareAggregator() throws Exception {
        this.aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getRuntimeContext().getUserCodeClassLoader());
        this.aggregator.open(new UnsupportedStateDataViewStore(((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getRuntimeContext()));
    }

    protected static final class WindowIsEmptyChecker
    implements Function<RowData, Boolean>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int indexOfCountStar;

        private WindowIsEmptyChecker(int indexOfCountStar, WindowAssigner assigner) {
            if (assigner instanceof SliceAssigners.HoppingSliceAssigner) {
                Preconditions.checkArgument((indexOfCountStar >= 0 ? 1 : 0) != 0, (Object)"Hopping window requires a COUNT(*) in the aggregate functions.");
            }
            this.indexOfCountStar = indexOfCountStar;
        }

        @Override
        public Boolean apply(@Nullable RowData acc) {
            if (this.indexOfCountStar < 0) {
                return false;
            }
            try {
                return acc == null || acc.getLong(this.indexOfCountStar) == 0L;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

