/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.FilterCondition;
import org.apache.flink.table.runtime.operators.join.lookup.LookupJoinRunner;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedLookupJoinWrapper
extends KeyedProcessFunction<RowData, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(KeyedLookupJoinWrapper.class);
    private static final String STATE_CLEARED_WARN_MSG = "The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.";
    private final LookupJoinRunner lookupJoinRunner;
    private final StateTtlConfig ttlConfig;
    private final TypeSerializer<RowData> serializer;
    private final boolean lookupKeyContainsPrimaryKey;
    private final boolean lenient = true;
    private transient BinaryRowData emptyRow;
    private transient ValueState<List<RowData>> state;
    private transient ValueState<RowData> uniqueState;
    private transient FetchedRecordListener collectListener;

    public KeyedLookupJoinWrapper(LookupJoinRunner lookupJoinRunner, StateTtlConfig ttlConfig, TypeSerializer<RowData> serializer, boolean lookupKeyContainsPrimaryKey) {
        this.lookupJoinRunner = lookupJoinRunner;
        this.ttlConfig = ttlConfig;
        this.serializer = serializer;
        this.lookupKeyContainsPrimaryKey = lookupKeyContainsPrimaryKey;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.lookupJoinRunner.setRuntimeContext(this.getRuntimeContext());
        this.lookupJoinRunner.open(DefaultOpenContext.INSTANCE);
        if (this.lookupKeyContainsPrimaryKey) {
            ValueStateDescriptor valueStateDescriptor = new ValueStateDescriptor("unique-value", this.serializer);
            if (this.ttlConfig.isEnabled()) {
                valueStateDescriptor.enableTimeToLive(this.ttlConfig);
            }
            this.uniqueState = this.getRuntimeContext().getState(valueStateDescriptor);
        } else {
            ValueStateDescriptor valueStateDescriptor = new ValueStateDescriptor("values", (TypeSerializer)new ListSerializer(this.serializer));
            if (this.ttlConfig.isEnabled()) {
                valueStateDescriptor.enableTimeToLive(this.ttlConfig);
            }
            this.state = this.getRuntimeContext().getState(valueStateDescriptor);
        }
        this.emptyRow = this.initEmptyRow(this.lookupJoinRunner.tableFieldsCount);
        this.collectListener = new FetchedRecordListener();
        this.lookupJoinRunner.collector.setCollectListener(this.collectListener);
    }

    private BinaryRowData initEmptyRow(int arity) {
        BinaryRowData emptyRow = new BinaryRowData(arity);
        int size = emptyRow.getFixedLengthPartSize();
        byte[] bytes = new byte[size];
        emptyRow.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, size);
        for (int index = 0; index < arity; ++index) {
            emptyRow.setNullAt(index);
        }
        return emptyRow;
    }

    public void processElement(RowData in, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        block7: {
            boolean collected;
            block8: {
                block11: {
                    block9: {
                        RowData rightRow;
                        block10: {
                            block6: {
                                this.lookupJoinRunner.prepareCollector(in, out);
                                this.collectListener.reset();
                                if (!RowDataUtil.isAccumulateMsg(in)) break block6;
                                if (this.lookupJoinRunner.preFilter(FilterCondition.Context.of(ctx), in)) {
                                    this.deleteState();
                                    this.lookupJoinRunner.doFetch(in);
                                    if (!this.collectListener.collected) {
                                        this.updateState((RowData)this.emptyRow);
                                    }
                                }
                                this.lookupJoinRunner.padNullForLeftJoin(in, out);
                                break block7;
                            }
                            collected = false;
                            if (!this.lookupJoinRunner.preFilter(FilterCondition.Context.of(ctx), in)) break block8;
                            if (!this.lookupKeyContainsPrimaryKey) break block9;
                            rightRow = (RowData)this.uniqueState.value();
                            if (null != rightRow) break block10;
                            this.stateStaledErrorHandle();
                            break block11;
                        }
                        if (this.emptyRow.equals((Object)rightRow)) break block11;
                        this.collectDeleteRow(in, rightRow, out);
                        collected = true;
                        break block11;
                    }
                    List rightRows = (List)this.state.value();
                    if (null == rightRows) {
                        this.stateStaledErrorHandle();
                    } else {
                        for (RowData row : rightRows) {
                            if (this.emptyRow.equals((Object)row)) continue;
                            this.collectDeleteRow(in, row, out);
                            collected = true;
                        }
                    }
                }
                this.deleteState();
            }
            if (this.lookupJoinRunner.isLeftOuterJoin && !collected) {
                this.collectDeleteRow(in, (RowData)this.lookupJoinRunner.nullRow, out);
            }
        }
    }

    private void collectDeleteRow(RowData in, RowData right, Collector<RowData> out) {
        this.lookupJoinRunner.outRow.replace(in, right);
        this.lookupJoinRunner.outRow.setRowKind(RowKind.DELETE);
        out.collect((Object)this.lookupJoinRunner.outRow);
    }

    public void close() throws Exception {
        this.lookupJoinRunner.close();
        super.close();
    }

    void deleteState() {
        if (this.lookupKeyContainsPrimaryKey) {
            this.uniqueState.clear();
        } else {
            this.state.clear();
        }
    }

    void updateState(RowData row) {
        try {
            if (this.lookupKeyContainsPrimaryKey) {
                this.uniqueState.update((Object)row);
            } else {
                ArrayList<RowData> rows = (ArrayList<RowData>)this.state.value();
                if (null == rows) {
                    rows = new ArrayList<RowData>();
                }
                rows.add(row);
                this.state.update(rows);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update state!", e);
        }
    }

    private void stateStaledErrorHandle() {
        LOG.warn(STATE_CLEARED_WARN_MSG);
    }

    class FetchedRecordListener
    implements ListenableCollector.CollectListener<RowData> {
        boolean collected;

        FetchedRecordListener() {
        }

        void reset() {
            this.collected = false;
        }

        @Override
        public void onCollect(RowData record) {
            this.collected = true;
            if (null == record) {
                KeyedLookupJoinWrapper.this.updateState((RowData)KeyedLookupJoinWrapper.this.emptyRow);
            } else {
                KeyedLookupJoinWrapper.this.updateState(record);
            }
        }
    }
}

