/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.window;

import java.time.ZoneId;
import java.util.List;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.JoinConditionWithNullFilters;
import org.apache.flink.table.runtime.operators.join.window.utils.WindowJoinHelper;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SlicingWindowTimerServiceImpl;
import org.apache.flink.table.runtime.operators.window.tvf.state.WindowListState;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.util.function.BiConsumerWithException;

public class WindowJoinOperator
extends TableStreamOperator<RowData>
implements TwoInputStreamOperator<RowData, RowData, RowData>,
Triggerable<RowData, Long>,
KeyContext {
    private static final long serialVersionUID = 1L;
    private static final String LEFT_RECORDS_STATE_NAME = "left-records";
    private static final String RIGHT_RECORDS_STATE_NAME = "right-records";
    private final RowDataSerializer leftSerializer;
    private final RowDataSerializer rightSerializer;
    private final GeneratedJoinCondition generatedJoinCondition;
    private final int leftWindowEndIndex;
    private final int rightWindowEndIndex;
    private final boolean[] filterNullKeys;
    private final ZoneId shiftTimeZone;
    private final FlinkJoinType joinType;
    private transient WindowTimerService<Long> windowTimerService;
    private transient JoinConditionWithNullFilters joinCondition;
    private transient TimestampedCollector<RowData> collector;
    private transient WindowListState<Long> leftWindowState;
    private transient WindowListState<Long> rightWindowState;
    private transient WindowJoinHelper helper;

    WindowJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, ZoneId shiftTimeZone, FlinkJoinType joinType) {
        this.leftSerializer = (RowDataSerializer)leftSerializer;
        this.rightSerializer = (RowDataSerializer)rightSerializer;
        this.generatedJoinCondition = generatedJoinCondition;
        this.leftWindowEndIndex = leftWindowEndIndex;
        this.rightWindowEndIndex = rightWindowEndIndex;
        this.filterNullKeys = filterNullKeys;
        this.shiftTimeZone = shiftTimeZone;
        this.joinType = joinType;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        this.collector.eraseTimestamp();
        LongSerializer windowSerializer = LongSerializer.INSTANCE;
        InternalTimerService internalTimerService = this.getInternalTimerService("window-timers", (TypeSerializer)windowSerializer, this);
        this.windowTimerService = new SlicingWindowTimerServiceImpl((InternalTimerService<Long>)internalTimerService, this.shiftTimeZone);
        JoinCondition condition = (JoinCondition)this.generatedJoinCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.joinCondition = new JoinConditionWithNullFilters(condition, this.filterNullKeys, this);
        this.joinCondition.setRuntimeContext((RuntimeContext)this.getRuntimeContext());
        this.joinCondition.open(DefaultOpenContext.INSTANCE);
        ListStateDescriptor leftRecordStateDesc = new ListStateDescriptor(LEFT_RECORDS_STATE_NAME, (TypeSerializer)this.leftSerializer);
        ListState leftListState = (ListState)this.getOrCreateKeyedState((TypeSerializer)windowSerializer, (StateDescriptor)leftRecordStateDesc);
        this.leftWindowState = new WindowListState((InternalListState)leftListState);
        ListStateDescriptor rightRecordStateDesc = new ListStateDescriptor(RIGHT_RECORDS_STATE_NAME, (TypeSerializer)this.rightSerializer);
        ListState rightListState = (ListState)this.getOrCreateKeyedState((TypeSerializer)windowSerializer, (StateDescriptor)rightRecordStateDesc);
        this.rightWindowState = new WindowListState((InternalListState)rightListState);
        this.helper = new SyncStateWindowJoinHelper();
        this.helper.registerMetric(this.getRuntimeContext().getMetricGroup());
    }

    public void close() throws Exception {
        super.close();
        this.collector = null;
        if (this.joinCondition != null) {
            this.joinCondition.close();
        }
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.helper.processElement(element, this.leftWindowEndIndex, this.helper.getLeftLateRecordsDroppedRate(), (BiConsumerWithException<Long, RowData, Exception>)((BiConsumerWithException)(windowEnd, rowData) -> this.leftWindowState.add((Long)windowEnd, (RowData)rowData)));
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.helper.processElement(element, this.rightWindowEndIndex, this.helper.getRightLateRecordsDroppedRate(), (BiConsumerWithException<Long, RowData, Exception>)((BiConsumerWithException)(windowEnd, rowData) -> this.rightWindowState.add((Long)windowEnd, (RowData)rowData)));
    }

    public void onProcessingTime(InternalTimer<RowData, Long> timer) throws Exception {
        throw new UnsupportedOperationException("This is a bug and should not happen. Please file an issue.");
    }

    public void onEventTime(InternalTimer<RowData, Long> timer) throws Exception {
        this.setCurrentKey(timer.getKey());
        Long window = (Long)timer.getNamespace();
        List<RowData> leftData = this.leftWindowState.get(window);
        List<RowData> rightData = this.rightWindowState.get(window);
        this.helper.joinAndClear(window, leftData, rightData);
    }

    private class SyncStateWindowJoinHelper
    extends WindowJoinHelper {
        public SyncStateWindowJoinHelper() {
            super(WindowJoinOperator.this.leftSerializer, WindowJoinOperator.this.rightSerializer, WindowJoinOperator.this.shiftTimeZone, WindowJoinOperator.this.windowTimerService, WindowJoinOperator.this.joinCondition, WindowJoinOperator.this.collector, WindowJoinOperator.this.joinType);
        }

        @Override
        public void clearState(long windowEnd, boolean isLeft) {
            if (isLeft) {
                WindowJoinOperator.this.leftWindowState.clear(windowEnd);
            } else {
                WindowJoinOperator.this.rightWindowState.clear(windowEnd);
            }
        }
    }
}

