/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.flink.cep.nfa.ComputationState;

public class NFAState {
    private Queue<ComputationState> partialMatches;
    private Queue<ComputationState> completedMatches;
    private boolean stateChanged;
    private boolean isNewStartPartialMatch;
    public static final Comparator<ComputationState> COMPUTATION_STATE_COMPARATOR = Comparator.comparingLong(c -> c.getStartEventID() != null ? c.getStartEventID().getTimestamp() : Long.MAX_VALUE).thenComparingInt(c -> c.getStartEventID() != null ? c.getStartEventID().getId() : Integer.MAX_VALUE);

    public NFAState(Iterable<ComputationState> states) {
        this.partialMatches = new PriorityQueue<ComputationState>(COMPUTATION_STATE_COMPARATOR);
        for (ComputationState startingState : states) {
            this.partialMatches.add(startingState);
        }
        this.completedMatches = new PriorityQueue<ComputationState>(COMPUTATION_STATE_COMPARATOR);
    }

    public NFAState(Queue<ComputationState> partialMatches, Queue<ComputationState> completedMatches) {
        this.partialMatches = partialMatches;
        this.completedMatches = completedMatches;
    }

    public boolean isStateChanged() {
        return this.stateChanged;
    }

    public void resetStateChanged() {
        this.stateChanged = false;
    }

    public void setStateChanged() {
        this.stateChanged = true;
    }

    public Queue<ComputationState> getPartialMatches() {
        return this.partialMatches;
    }

    public Queue<ComputationState> getCompletedMatches() {
        return this.completedMatches;
    }

    public void setNewPartialMatches(PriorityQueue<ComputationState> newPartialMatches) {
        this.partialMatches = newPartialMatches;
    }

    public boolean isNewStartPartialMatch() {
        return this.isNewStartPartialMatch;
    }

    public void resetNewStartPartialMatch() {
        this.isNewStartPartialMatch = false;
    }

    public void setNewStartPartiailMatch() {
        this.isNewStartPartialMatch = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NFAState nfaState = (NFAState)o;
        return Arrays.equals(this.partialMatches.toArray(), nfaState.partialMatches.toArray()) && Arrays.equals(this.completedMatches.toArray(), nfaState.completedMatches.toArray());
    }

    public int hashCode() {
        return Objects.hash(this.partialMatches, this.completedMatches);
    }

    public String toString() {
        return "NFAState{partialMatches=" + String.valueOf(this.partialMatches) + ", completedMatches=" + String.valueOf(this.completedMatches) + ", stateChanged=" + this.stateChanged + "}";
    }
}

