/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.metrics;

import java.util.HashMap;
import org.apache.flink.agents.plan.AgentPlan;
import org.apache.flink.agents.runtime.metrics.BuiltInActionMetrics;
import org.apache.flink.agents.runtime.metrics.FlinkAgentsMetricGroupImpl;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;

public class BuiltInMetrics {
    private final Meter numOfEventProcessedPerSec;
    private final Meter numOfActionsExecutedPerSec;
    private final HashMap<String, BuiltInActionMetrics> actionMetricGroups;

    public BuiltInMetrics(FlinkAgentsMetricGroupImpl parentMetricGroup, AgentPlan agentPlan) {
        Counter numOfEventsProcessed = parentMetricGroup.getCounter("numOfEventProcessed");
        this.numOfEventProcessedPerSec = parentMetricGroup.getMeter("numOfEventProcessedPerSec", numOfEventsProcessed);
        Counter numOfActionsExecuted = parentMetricGroup.getCounter("numOfActionsExecuted");
        this.numOfActionsExecutedPerSec = parentMetricGroup.getMeter("numOfActionsExecutedPerSec", numOfActionsExecuted);
        this.actionMetricGroups = new HashMap();
        for (String actionName : agentPlan.getActions().keySet()) {
            this.actionMetricGroups.put(actionName, new BuiltInActionMetrics(parentMetricGroup.getSubGroup(actionName)));
        }
    }

    public void markEventProcessed() {
        this.numOfEventProcessedPerSec.markEvent();
    }

    public void markActionExecuted(String actionName) {
        this.numOfActionsExecutedPerSec.markEvent();
        this.actionMetricGroups.get(actionName).markActionExecuted();
    }
}

