/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.graph;

import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

public final class StreamGraphUtils {
    public static void validateTransformationUid(StreamGraph streamGraph, Transformation<?> transformation) {
        if (!streamGraph.getExecutionConfig().hasAutoGeneratedUIDsEnabled() && transformation instanceof PhysicalTransformation && transformation.getUserProvidedNodeHash() == null && transformation.getUid() == null) {
            throw new IllegalStateException("Auto generated UIDs have been disabled but no UID or hash has been assigned to operator " + transformation.getName());
        }
    }

    public static <T> void configureBufferTimeout(StreamGraph streamGraph, int nodeId, Transformation<T> transformation, long defaultBufferTimeout) {
        if (transformation.getBufferTimeout() >= 0L) {
            streamGraph.setBufferTimeout(nodeId, transformation.getBufferTimeout());
        } else {
            streamGraph.setBufferTimeout(nodeId, defaultBufferTimeout);
        }
    }
}

