/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;

public class StructColumnVector
extends ColumnVector {
    public ColumnVector[] fields;

    public StructColumnVector() {
        this(1024, new ColumnVector[0]);
    }

    public StructColumnVector(int len, ColumnVector ... fields) {
        super(len);
        this.fields = fields;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].flatten(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.isRepeating) {
            inputElementNum = 0;
        }
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            ColumnVector[] inputFields = ((StructColumnVector)inputVector).fields;
            for (int i = 0; i < inputFields.length; ++i) {
                this.fields[i].setElement(outElementNum, inputElementNum, inputFields[i]);
            }
        } else {
            this.noNulls = false;
            this.isNull[outElementNum] = true;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append('[');
            for (int i = 0; i < this.fields.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                this.fields[i].stringifyValue(buffer, row);
            }
            buffer.append(']');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].ensureSize(size, preserveData);
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].reset();
        }
    }

    @Override
    public void init() {
        super.init();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].init();
        }
    }

    @Override
    public void unFlatten() {
        super.unFlatten();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].unFlatten();
        }
    }

    @Override
    public void setRepeating(boolean isRepeating) {
        super.setRepeating(isRepeating);
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setRepeating(isRepeating);
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        throw new UnsupportedOperationException();
    }
}

