/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.gravitino.server.web.ApiVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(VersioningFilter.class);
    private static final Pattern ACCEPT_VERSION_REGEX = Pattern.compile("application/vnd\\.gravitino\\.v(\\d+)\\+json");
    private static final String ACCEPT_VERSION_HEADER = "Accept";

    private static String getAcceptVersion(int version) {
        return String.format("application/vnd.gravitino.v%d+json", version);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Enumeration acceptHeader = req.getHeaders(ACCEPT_VERSION_HEADER);
        while (acceptHeader.hasMoreElements()) {
            String value = (String)acceptHeader.nextElement();
            Matcher m = ACCEPT_VERSION_REGEX.matcher(value);
            if (!m.find()) continue;
            int version = Integer.parseInt(m.group(1));
            if (!ApiVersion.isSupportedVersion(version)) {
                LOG.error("Unsupported version v{} in Request Header {}.", (Object)version, (Object)value);
                HttpServletResponse resp = (HttpServletResponse)response;
                resp.sendError(406, "Unsupported version");
            } else {
                chain.doFilter(request, response);
            }
            return;
        }
        MutableHttpServletRequest mutableRequest = new MutableHttpServletRequest(req);
        ApiVersion latest = ApiVersion.latestVersion();
        mutableRequest.putHeader(ACCEPT_VERSION_HEADER, VersioningFilter.getAcceptVersion(latest.version()));
        chain.doFilter((ServletRequest)mutableRequest, response);
    }

    public void destroy() {
    }

    static final class MutableHttpServletRequest
    extends HttpServletRequestWrapper {
        private final Map<String, String> customHeaders = new HashMap<String, String>();

        public MutableHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public void putHeader(String name, String value) {
            this.customHeaders.put(name, value);
        }

        public String getHeader(String name) {
            String headerValue = this.customHeaders.get(name);
            if (headerValue != null) {
                return headerValue;
            }
            return ((HttpServletRequest)this.getRequest()).getHeader(name);
        }

        public Enumeration<String> getHeaderNames() {
            ArrayList<String> combinedHeaderNames = new ArrayList<String>(this.customHeaders.keySet());
            Enumeration headerNames = ((HttpServletRequest)this.getRequest()).getHeaderNames();
            while (headerNames.hasMoreElements()) {
                combinedHeaderNames.add((String)headerNames.nextElement());
            }
            return Collections.enumeration(combinedHeaderNames);
        }
    }
}

