/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.CatalogOperations;
import org.apache.gravitino.server.web.rest.FilesetOperations;
import org.apache.gravitino.server.web.rest.GroupOperations;
import org.apache.gravitino.server.web.rest.MetalakeOperations;
import org.apache.gravitino.server.web.rest.ModelOperations;
import org.apache.gravitino.server.web.rest.OwnerOperations;
import org.apache.gravitino.server.web.rest.PermissionOperations;
import org.apache.gravitino.server.web.rest.RoleOperations;
import org.apache.gravitino.server.web.rest.SchemaOperations;
import org.apache.gravitino.server.web.rest.TableOperations;
import org.apache.gravitino.server.web.rest.TopicOperations;
import org.apache.gravitino.server.web.rest.UserOperations;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InterceptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoInterceptionService
implements InterceptionService {
    public Filter getDescriptorFilter() {
        return new ClassListFilter((Set<String>)ImmutableSet.of((Object)MetalakeOperations.class.getName(), (Object)CatalogOperations.class.getName(), (Object)SchemaOperations.class.getName(), (Object)TableOperations.class.getName(), (Object)ModelOperations.class.getName(), (Object)TopicOperations.class.getName(), (Object[])new String[]{FilesetOperations.class.getName(), UserOperations.class.getName(), GroupOperations.class.getName(), PermissionOperations.class.getName(), RoleOperations.class.getName(), OwnerOperations.class.getName()}));
    }

    public List<MethodInterceptor> getMethodInterceptors(Method method) {
        return ImmutableList.of((Object)new MetadataAuthorizationMethodInterceptor());
    }

    public List<ConstructorInterceptor> getConstructorInterceptors(Constructor<?> constructor) {
        return Collections.emptyList();
    }

    private static class ClassListFilter
    implements Filter {
        private final Set<String> targetClasses;

        public ClassListFilter(Set<String> targetClasses) {
            this.targetClasses = new HashSet<String>(targetClasses);
        }

        public boolean matches(Descriptor descriptor) {
            String implementation = descriptor.getImplementation();
            return this.targetClasses.contains(implementation);
        }
    }

    private static class MetadataAuthorizationMethodInterceptor
    implements MethodInterceptor {
        private static final Logger LOG = LoggerFactory.getLogger(MetadataAuthorizationMethodInterceptor.class);

        private MetadataAuthorizationMethodInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            try {
                Map<String, Object> pathParams;
                Object[] args;
                Map<Entity.EntityType, NameIdentifier> metadataContext;
                String expression;
                AuthorizationExpressionEvaluator authorizationExpressionEvaluator;
                boolean authorizeResult;
                Method method = methodInvocation.getMethod();
                Parameter[] parameters = method.getParameters();
                AuthorizationExpression expressionAnnotation = method.getAnnotation(AuthorizationExpression.class);
                if (expressionAnnotation != null && !(authorizeResult = (authorizationExpressionEvaluator = new AuthorizationExpressionEvaluator(expression = expressionAnnotation.expression())).evaluate(metadataContext = this.extractNameIdentifierFromParameters(parameters, args = methodInvocation.getArguments()), pathParams = this.extractPathParamsFromParameters(parameters, args), new AuthorizationRequestContext()))) {
                    MetadataObject.Type type = expressionAnnotation.accessMetadataType();
                    NameIdentifier accessMetadataName = metadataContext.get(Entity.EntityType.valueOf((String)type.name()));
                    String errorMessage = expressionAnnotation.errorMessage();
                    String currentUser = PrincipalUtils.getCurrentUserName();
                    String methodName = method.getName();
                    LOG.warn("Authorization failed - User: {}, Operation: {}, Metadata: {}, Expression: {}", new Object[]{currentUser, methodName, accessMetadataName, expression});
                    return this.buildNoAuthResponse(errorMessage, accessMetadataName, currentUser, methodName);
                }
                return methodInvocation.proceed();
            }
            catch (Exception ex) {
                String currentUser = PrincipalUtils.getCurrentUserName();
                String methodName = methodInvocation.getMethod().getName();
                LOG.error("System internal error during authorization - User: {}, Operation: {}", new Object[]{currentUser, methodName, ex});
                return Utils.internalError((String)"Authorization failed due to system internal error. Please contact administrator.", (Throwable)ex);
            }
        }

        private Response buildNoAuthResponse(String errorMessage, NameIdentifier accessMetadataName, String currentUser, String methodName) {
            String accessMetadataMessage = accessMetadataName != null ? String.format("on metadata '%s'", accessMetadataName.name()) : "";
            String contextualMessage = StringUtils.isNotBlank((CharSequence)errorMessage) ? String.format("User '%s' is not authorized to perform operation '%s' %s: %s", currentUser, methodName, accessMetadataMessage, errorMessage) : String.format("User '%s' is not authorized to perform operation '%s' %s", currentUser, methodName, accessMetadataMessage);
            return Utils.forbidden((String)contextualMessage, null);
        }

        private Map<Entity.EntityType, NameIdentifier> extractNameIdentifierFromParameters(Parameter[] parameters, Object[] args) {
            HashMap<Entity.EntityType, String> entities = new HashMap<Entity.EntityType, String>();
            HashMap<Entity.EntityType, NameIdentifier> nameIdentifierMap = new HashMap<Entity.EntityType, NameIdentifier>();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                AuthorizationMetadata authorizeResource = parameter.getAnnotation(AuthorizationMetadata.class);
                if (authorizeResource == null) continue;
                Entity.EntityType type2 = authorizeResource.type();
                entities.put(type2, String.valueOf(args[i]));
            }
            String metalake = (String)entities.get(Entity.EntityType.METALAKE);
            String catalog = (String)entities.get(Entity.EntityType.CATALOG);
            String schema = (String)entities.get(Entity.EntityType.SCHEMA);
            String table = (String)entities.get(Entity.EntityType.TABLE);
            String topic = (String)entities.get(Entity.EntityType.TOPIC);
            String fileset = (String)entities.get(Entity.EntityType.FILESET);
            entities.forEach((type, metadata) -> {
                switch (type) {
                    case CATALOG: {
                        nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.ofCatalog((String)metalake, (String)catalog));
                        break;
                    }
                    case SCHEMA: {
                        nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)schema));
                        break;
                    }
                    case TABLE: {
                        nameIdentifierMap.put(Entity.EntityType.TABLE, NameIdentifierUtil.ofTable((String)metalake, (String)catalog, (String)schema, (String)table));
                        break;
                    }
                    case TOPIC: {
                        nameIdentifierMap.put(Entity.EntityType.TOPIC, NameIdentifierUtil.ofTopic((String)metalake, (String)catalog, (String)schema, (String)topic));
                        break;
                    }
                    case FILESET: {
                        nameIdentifierMap.put(Entity.EntityType.FILESET, NameIdentifierUtil.ofFileset((String)metalake, (String)catalog, (String)schema, (String)fileset));
                        break;
                    }
                    case MODEL: {
                        String model = (String)entities.get(Entity.EntityType.MODEL);
                        nameIdentifierMap.put(Entity.EntityType.MODEL, NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model));
                        break;
                    }
                    case METALAKE: {
                        nameIdentifierMap.put(Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)metalake));
                        break;
                    }
                    case USER: {
                        nameIdentifierMap.put(Entity.EntityType.USER, NameIdentifierUtil.ofUser((String)metadata, (String)((String)entities.get(Entity.EntityType.USER))));
                        break;
                    }
                    case GROUP: {
                        nameIdentifierMap.put(Entity.EntityType.GROUP, NameIdentifierUtil.ofGroup((String)metalake, (String)((String)entities.get(Entity.EntityType.GROUP))));
                        break;
                    }
                    case ROLE: {
                        nameIdentifierMap.put(Entity.EntityType.ROLE, NameIdentifierUtil.ofRole((String)metalake, (String)((String)entities.get(Entity.EntityType.ROLE))));
                        break;
                    }
                }
            });
            return nameIdentifierMap;
        }

        private Map<String, Object> extractPathParamsFromParameters(Parameter[] parameters, Object[] args) {
            HashMap<String, Object> pathParams = new HashMap<String, Object>();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                PathParam pathParam = parameter.getAnnotation(PathParam.class);
                if (pathParam == null) continue;
                pathParams.put("p_" + pathParam.value(), args[i]);
            }
            return pathParams;
        }
    }
}

