/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CatalogDispatcher;
import org.apache.gravitino.dto.requests.CatalogCreateRequest;
import org.apache.gravitino.dto.requests.CatalogSetRequest;
import org.apache.gravitino.dto.requests.CatalogUpdateRequest;
import org.apache.gravitino.dto.requests.CatalogUpdatesRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.CatalogListResponse;
import org.apache.gravitino.dto.responses.CatalogResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.server.authorization.MetadataFilterHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/catalogs")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CatalogOperations {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogOperations.class);
    private final CatalogDispatcher catalogDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public CatalogOperations(CatalogDispatcher catalogDispatcher) {
        this.catalogDispatcher = catalogDispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-catalog.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-catalog", absolute=true)
    public Response listCatalogs(@PathParam(value="metalake") String metalake, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list catalog {} request for metalake: {}, ", (Object)(verbose ? "infos" : "names"), (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Namespace catalogNS = NamespaceUtil.ofCatalog((String)metalake);
                if (verbose) {
                    Object[] catalogs = this.catalogDispatcher.listCatalogsInfo(catalogNS);
                    catalogs = (Catalog[])MetadataFilterHelper.filterByExpression((String)metalake, (String)"ANY_USE_CATALOG || ANY(OWNER, METALAKE, CATALOG)", (Entity.EntityType)Entity.EntityType.CATALOG, (Object[])catalogs, catalogEntity -> NameIdentifierUtil.ofCatalog((String)metalake, (String)catalogEntity.name()));
                    Response response = Utils.ok((Object)new CatalogListResponse(DTOConverters.toDTOs((Catalog[])catalogs)));
                    LOG.info("List {} catalogs info under metalake: {}", (Object)catalogs.length, (Object)metalake);
                    return response;
                }
                NameIdentifier[] idents = this.catalogDispatcher.listCatalogs(catalogNS);
                idents = MetadataFilterHelper.filterByExpression((String)metalake, (String)"ANY_USE_CATALOG || ANY(OWNER, METALAKE, CATALOG)", (Entity.EntityType)Entity.EntityType.CATALOG, (NameIdentifier[])idents);
                Response response = Utils.ok((Object)new EntityListResponse(idents));
                LOG.info("List {} catalogs under metalake: {}", (Object)idents.length, (Object)metalake);
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleCatalogException(OperationType.LIST, "", metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-catalog.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-catalog", absolute=true)
    @AuthorizationExpression(expression="METALAKE::CREATE_CATALOG || METALAKE::OWNER", accessMetadataType=MetadataObject.Type.METALAKE)
    public Response createCatalog(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, CatalogCreateRequest request) {
        LOG.info("Received create catalog request for metalake: {}", (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofCatalog((String)metalake, (String)request.getName());
                Catalog catalog = this.catalogDispatcher.createCatalog(ident, request.getType(), request.getProvider(), request.getComment(), request.getProperties());
                Response response = Utils.ok((Object)new CatalogResponse(DTOConverters.toDTO((Catalog)catalog)));
                LOG.info("Catalog created: {}.{}", (Object)metalake, (Object)catalog.name());
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleCatalogException(OperationType.CREATE, request.getName(), metalake, e);
        }
    }

    @POST
    @Path(value="testConnection")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="test-connection.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="test-connection", absolute=true)
    public Response testConnection(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, CatalogCreateRequest request) {
        LOG.info("Received test connection request for catalog: {}.{}", (Object)metalake, (Object)request.getName());
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofCatalog((String)metalake, (String)request.getName());
                this.catalogDispatcher.testConnection(ident, request.getType(), request.getProvider(), request.getComment(), request.getProperties());
                Response response = Utils.ok((Object)new BaseResponse());
                LOG.info("Successfully test connection for catalog: {}.{}", (Object)metalake, (Object)request.getName());
                return response;
            });
        }
        catch (Exception e) {
            LOG.info("Failed to test connection for catalog: {}.{}", (Object)metalake, (Object)request.getName());
            return ExceptionHandlers.handleTestConnectionException(e);
        }
    }

    @PATCH
    @Path(value="{catalog}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="set-catalog.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="set-catalog", absolute=true)
    @AuthorizationExpression(expression="ANY_USE_CATALOG || ANY(OWNER, METALAKE, CATALOG)", accessMetadataType=MetadataObject.Type.CATALOG)
    public Response setCatalog(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalogName, CatalogSetRequest request) {
        LOG.info("Received set request for catalog: {}.{}", (Object)metalake, (Object)catalogName);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofCatalog((String)metalake, (String)catalogName);
                if (request.isInUse()) {
                    this.catalogDispatcher.enableCatalog(ident);
                } else {
                    this.catalogDispatcher.disableCatalog(ident);
                }
                Response response = Utils.ok((Object)new BaseResponse());
                LOG.info("Successfully {} catalog: {}.{}", new Object[]{request.isInUse() ? "enable" : "disable", metalake, catalogName});
                return response;
            });
        }
        catch (Exception e) {
            LOG.info("Failed to {} catalog: {}.{}", new Object[]{request.isInUse() ? "enable" : "disable", metalake, catalogName});
            return ExceptionHandlers.handleCatalogException(OperationType.ENABLE, catalogName, metalake, e);
        }
    }

    @GET
    @Path(value="{catalog}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="load-catalog.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-catalog", absolute=true)
    @AuthorizationExpression(expression="ANY_USE_CATALOG || ANY(OWNER, METALAKE, CATALOG)", accessMetadataType=MetadataObject.Type.CATALOG)
    public Response loadCatalog(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalakeName, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalogName) {
        LOG.info("Received load catalog request for catalog: {}.{}", (Object)metalakeName, (Object)catalogName);
        try {
            NameIdentifier ident = NameIdentifierUtil.ofCatalog((String)metalakeName, (String)catalogName);
            Catalog catalog = this.catalogDispatcher.loadCatalog(ident);
            Response response = Utils.ok((Object)new CatalogResponse(DTOConverters.toDTO((Catalog)catalog)));
            LOG.info("Catalog loaded: {}.{}", (Object)metalakeName, (Object)catalogName);
            return response;
        }
        catch (Exception e) {
            return ExceptionHandlers.handleCatalogException(OperationType.LOAD, catalogName, metalakeName, e);
        }
    }

    @PUT
    @Path(value="{catalog}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-catalog.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-catalog", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG)", accessMetadataType=MetadataObject.Type.CATALOG)
    public Response alterCatalog(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalakeName, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalogName, CatalogUpdatesRequest request) {
        LOG.info("Received alter catalog request for catalog: {}.{}", (Object)metalakeName, (Object)catalogName);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofCatalog((String)metalakeName, (String)catalogName);
                CatalogChange[] changes = (CatalogChange[])request.getUpdates().stream().map(CatalogUpdateRequest::catalogChange).toArray(CatalogChange[]::new);
                Catalog catalog = this.catalogDispatcher.alterCatalog(ident, changes);
                Response response = Utils.ok((Object)new CatalogResponse(DTOConverters.toDTO((Catalog)catalog)));
                LOG.info("Catalog altered: {}.{}", (Object)metalakeName, (Object)catalog.name());
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleCatalogException(OperationType.ALTER, catalogName, metalakeName, e);
        }
    }

    @DELETE
    @Path(value="{catalog}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-catalog.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-catalog", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG)", accessMetadataType=MetadataObject.Type.CATALOG)
    public Response dropCatalog(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalakeName, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalogName, @DefaultValue(value="false") @QueryParam(value="force") boolean force) {
        LOG.info("Received drop catalog request for catalog: {}.{}", (Object)metalakeName, (Object)catalogName);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofCatalog((String)metalakeName, (String)catalogName);
                boolean dropped = this.catalogDispatcher.dropCatalog(ident, force);
                if (!dropped) {
                    LOG.warn("Failed to drop catalog {} under metalake {}", (Object)catalogName, (Object)metalakeName);
                } else {
                    LOG.info("Catalog dropped: {}.{}", (Object)metalakeName, (Object)catalogName);
                }
                Response response = Utils.ok((Object)new DropResponse(Boolean.valueOf(dropped)));
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleCatalogException(OperationType.DROP, catalogName, metalakeName, e);
        }
    }
}

