/*
 * Decompiled with CFR 0.152.
 */
package ognl.internal.entry;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ognl.OgnlRuntime;
import ognl.internal.CacheException;
import ognl.internal.entry.CacheEntryFactory;
import ognl.internal.entry.MethodCacheEntry;

public abstract class MethodCacheEntryFactory<T extends MethodCacheEntry>
implements CacheEntryFactory<T, Map<String, List<Method>>> {
    @Override
    public Map<String, List<Method>> create(T key) throws CacheException {
        HashMap<String, List<Method>> result = new HashMap<String, List<Method>>(23);
        this.collectMethods(key, ((MethodCacheEntry)key).targetClass, result);
        return result;
    }

    protected abstract boolean shouldCache(T var1, Method var2);

    private void collectMethods(T key, Class<?> c, Map<String, List<Method>> result) {
        Method[] ma;
        try {
            ma = c.getDeclaredMethods();
        }
        catch (SecurityException ignored) {
            ma = c.getMethods();
        }
        for (Method method : ma) {
            if (!OgnlRuntime.isMethodCallable(method) || !this.shouldCache(key, method)) continue;
            List ml = result.computeIfAbsent(method.getName(), k -> new ArrayList());
            ml.add(method);
        }
        Class<?> superclass = c.getSuperclass();
        if (superclass != null) {
            this.collectMethods(key, superclass, result);
        }
        for (Class<?> iface : c.getInterfaces()) {
            this.collectMethods(key, iface, result);
        }
    }
}

