/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ClientGSIContext
implements AlignmentContext {
    private final AtomicLong lastSeenStateId = new AtomicLong(Long.MIN_VALUE);

    public long getLastSeenStateId() {
        return this.lastSeenStateId.get();
    }

    public boolean isCoordinatedCall(String protocolName, String method) {
        throw new UnsupportedOperationException("Client should not be checking uncoordinated call");
    }

    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
    }

    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
        this.updateMax(header.getStateId());
    }

    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
        header.setStateId(this.lastSeenStateId.longValue());
    }

    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long threshold) throws IOException {
        return 0L;
    }

    private void updateMax(long sample) {
        boolean setSuccessful;
        long curMax;
        while ((curMax = this.lastSeenStateId.get()) < sample && !(setSuccessful = this.lastSeenStateId.compareAndSet(curMax, sample))) {
        }
    }
}

