/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.annotation.DeveloperApi;

@DeveloperApi
public final class MetalakeInfo {
    private final String name;
    @Nullable
    private final String comment;
    private final Map<String, String> properties;
    @Nullable
    private final Audit audit;

    public MetalakeInfo(Metalake metalake) {
        this(metalake.name(), metalake.comment(), metalake.properties(), metalake.auditInfo());
    }

    public MetalakeInfo(String name, String comment, Map<String, String> properties, Audit audit) {
        this.name = name;
        this.comment = comment;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.audit = audit;
    }

    @Nullable
    public Audit auditInfo() {
        return this.audit;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }
}

