/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class SecurableObjectPO {
    private Long roleId;
    private Long metadataObjectId;
    private String type;
    private String privilegeNames;
    private String privilegeConditions;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getRoleId() {
        return this.roleId;
    }

    public Long getMetadataObjectId() {
        return this.metadataObjectId;
    }

    public String getType() {
        return this.type;
    }

    public String getPrivilegeNames() {
        return this.privilegeNames;
    }

    public String getPrivilegeConditions() {
        return this.privilegeConditions;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurableObjectPO)) {
            return false;
        }
        SecurableObjectPO securableObjectPO = (SecurableObjectPO)o;
        return Objects.equal((Object)this.getRoleId(), (Object)securableObjectPO.getRoleId()) && Objects.equal((Object)this.getMetadataObjectId(), (Object)securableObjectPO.getMetadataObjectId()) && Objects.equal((Object)this.getType(), (Object)securableObjectPO.getType()) && Objects.equal((Object)this.getPrivilegeConditions(), (Object)securableObjectPO.getPrivilegeConditions()) && Objects.equal((Object)this.getPrivilegeNames(), (Object)securableObjectPO.getPrivilegeNames()) && Objects.equal((Object)this.getCurrentVersion(), (Object)securableObjectPO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)securableObjectPO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)securableObjectPO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getRoleId(), this.getMetadataObjectId(), this.getType(), this.getPrivilegeNames(), this.getPrivilegeConditions(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SecurableObjectPO securableObjectPO = new SecurableObjectPO();

        private Builder() {
        }

        public Builder withRoleId(Long roleId) {
            this.securableObjectPO.roleId = roleId;
            return this;
        }

        public Builder withMetadataObjectId(long metadataObjectId) {
            this.securableObjectPO.metadataObjectId = metadataObjectId;
            return this;
        }

        public Builder withType(String type) {
            this.securableObjectPO.type = type;
            return this;
        }

        public Builder withPrivilegeNames(String privilegeNames) {
            this.securableObjectPO.privilegeNames = privilegeNames;
            return this;
        }

        public Builder withPrivilegeConditions(String privilegeConditions) {
            this.securableObjectPO.privilegeConditions = privilegeConditions;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.securableObjectPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.securableObjectPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.securableObjectPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.securableObjectPO.roleId != null ? 1 : 0) != 0, (Object)"Role id is required");
            Preconditions.checkArgument((this.securableObjectPO.type != null ? 1 : 0) != 0, (Object)"Type is required");
            Preconditions.checkArgument((this.securableObjectPO.privilegeNames != null ? 1 : 0) != 0, (Object)"Privilege names are required");
            Preconditions.checkArgument((this.securableObjectPO.privilegeConditions != null ? 1 : 0) != 0, (Object)"Privilege conditions are required");
            Preconditions.checkArgument((this.securableObjectPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.securableObjectPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.securableObjectPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public SecurableObjectPO build() {
            this.validate();
            return this.securableObjectPO;
        }
    }
}

