/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.reader;

import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarMap;
import org.apache.paimon.format.orc.reader.AbstractOrcColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.types.MapType;

public class OrcMapColumnVector
extends AbstractOrcColumnVector
implements org.apache.paimon.data.columnar.MapColumnVector {
    private final MapColumnVector hiveVector;
    private final ColumnVector keyPaimonVector;
    private final ColumnVector valuePaimonVector;

    public OrcMapColumnVector(MapColumnVector hiveVector, VectorizedRowBatch orcBatch, MapType type, boolean legacyTimestampLtzType) {
        super(hiveVector, orcBatch);
        this.hiveVector = hiveVector;
        this.keyPaimonVector = OrcMapColumnVector.createPaimonVector(hiveVector.keys, orcBatch, type.getKeyType(), legacyTimestampLtzType);
        this.valuePaimonVector = OrcMapColumnVector.createPaimonVector(hiveVector.values, orcBatch, type.getValueType(), legacyTimestampLtzType);
    }

    public InternalMap getMap(int i) {
        i = this.rowMapper(i);
        long offset = this.hiveVector.offsets[i];
        long length = this.hiveVector.lengths[i];
        return new ColumnarMap(this.keyPaimonVector, this.valuePaimonVector, (int)offset, (int)length);
    }

    public ColumnVector[] getChildren() {
        return new ColumnVector[]{this.keyPaimonVector, this.valuePaimonVector};
    }
}

