/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.writer;

import java.io.IOException;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.paimon.utils.Preconditions;

public class ParquetBulkWriter
implements FormatWriter {
    private final ParquetWriter<InternalRow> parquetWriter;

    public ParquetBulkWriter(ParquetWriter<InternalRow> parquetWriter) {
        this.parquetWriter = (ParquetWriter)Preconditions.checkNotNull(parquetWriter, (String)"parquetWriter");
    }

    public void addElement(InternalRow datum) throws IOException {
        this.parquetWriter.write(datum);
    }

    public void close() throws IOException {
        this.parquetWriter.close();
    }

    public boolean reachTargetSize(boolean suggestedCheck, long targetSize) throws IOException {
        return suggestedCheck && this.parquetWriter.getDataSize() >= targetSize;
    }
}

