/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.orc.CompressionCodec;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.HadoopShims;

public class ZlibCodec
implements CompressionCodec,
DirectDecompressionCodec {
    private static final HadoopShims SHIMS = HadoopShims.Factory.get();
    private HadoopShims.DirectDecompressor decompressShim = null;
    private Boolean direct = null;
    private int level;
    private int strategy;

    public ZlibCodec() {
        this.level = -1;
        this.strategy = 0;
    }

    private ZlibCodec(int level, int strategy) {
        this.level = level;
        this.strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow) throws IOException {
        int length = in.remaining();
        int outSize = 0;
        Deflater deflater = new Deflater(this.level, true);
        try {
            deflater.setStrategy(this.strategy);
            deflater.setInput(in.array(), in.arrayOffset() + in.position(), length);
            deflater.finish();
            int offset = out.arrayOffset() + out.position();
            while (!deflater.finished() && length > outSize) {
                int size = deflater.deflate(out.array(), offset, out.remaining());
                out.position(size + out.position());
                outSize += size;
                offset += size;
                if (out.remaining() != 0) continue;
                if (overflow == null) {
                    boolean bl = false;
                    return bl;
                }
                out = overflow;
                offset = out.arrayOffset() + out.position();
            }
        }
        finally {
            deflater.end();
        }
        return length > outSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        Inflater inflater = new Inflater(true);
        try {
            inflater.setInput(in.array(), in.arrayOffset() + in.position(), in.remaining());
            while (!(inflater.finished() || inflater.needsDictionary() || inflater.needsInput())) {
                try {
                    int count = inflater.inflate(out.array(), out.arrayOffset() + out.position(), out.remaining());
                    out.position(count + out.position());
                }
                catch (DataFormatException dfe) {
                    throw new IOException("Bad compression data", dfe);
                }
            }
            out.flip();
        }
        finally {
            inflater.end();
        }
        in.position(in.limit());
    }

    @Override
    public boolean isAvailable() {
        if (this.direct == null) {
            try {
                this.ensureShim();
                this.direct = this.decompressShim != null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.direct = false;
            }
        }
        return this.direct;
    }

    private void ensureShim() {
        if (this.decompressShim == null) {
            this.decompressShim = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.ZLIB_NOHEADER);
        }
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        this.ensureShim();
        this.decompressShim.decompress(in, out);
        out.flip();
    }

    @Override
    public CompressionCodec modify(EnumSet<CompressionCodec.Modifier> modifiers) {
        if (modifiers == null) {
            return this;
        }
        int l = this.level;
        int s = this.strategy;
        for (CompressionCodec.Modifier m : modifiers) {
            switch (m) {
                case BINARY: {
                    s = 1;
                    break;
                }
                case TEXT: {
                    s = 0;
                    break;
                }
                case FASTEST: {
                    l = 1;
                    break;
                }
                case FAST: {
                    l = 2;
                    break;
                }
                case DEFAULT: {
                    l = -1;
                    break;
                }
            }
        }
        return new ZlibCodec(l, s);
    }

    @Override
    public void reset() {
        this.level = -1;
        this.strategy = 0;
        if (this.decompressShim != null) {
            this.decompressShim.reset();
        }
    }

    @Override
    public void close() {
        if (this.decompressShim != null) {
            this.decompressShim.end();
        }
    }
}

