/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.file.Fileset;

public class FilesetDTO
implements Fileset {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="type")
    private Fileset.Type type;
    @JsonProperty(value="storageLocation")
    private String storageLocation;
    @JsonProperty(value="storageLocations")
    private Map<String, String> storageLocations;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    private FilesetDTO() {
    }

    private FilesetDTO(String name, String comment, Fileset.Type type, String storageLocation, Map<String, String> storageLocations, Map<String, String> properties, AuditDTO audit) {
        this.name = name;
        this.comment = comment;
        this.type = type;
        this.storageLocation = storageLocation;
        this.storageLocations = storageLocations;
        this.properties = properties;
        this.audit = audit;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Fileset.Type type() {
        return this.type;
    }

    public Map<String, String> storageLocations() {
        return this.storageLocations;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public AuditDTO auditInfo() {
        return this.audit;
    }

    public static FilesetDTOBuilder builder() {
        return new FilesetDTOBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesetDTO)) {
            return false;
        }
        FilesetDTO other = (FilesetDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Fileset.Type this$type = this.type;
        Fileset.Type other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$storageLocation = this.storageLocation;
        String other$storageLocation = other.storageLocation;
        if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
            return false;
        }
        Map<String, String> this$storageLocations = this.storageLocations;
        Map<String, String> other$storageLocations = other.storageLocations;
        if (this$storageLocations == null ? other$storageLocations != null : !((Object)this$storageLocations).equals(other$storageLocations)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        AuditDTO this$audit = this.audit;
        AuditDTO other$audit = other.audit;
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilesetDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Fileset.Type $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $storageLocation = this.storageLocation;
        result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
        Map<String, String> $storageLocations = this.storageLocations;
        result = result * 59 + ($storageLocations == null ? 43 : ((Object)$storageLocations).hashCode());
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        AuditDTO $audit = this.audit;
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public static class FilesetDTOBuilder {
        private String name;
        private String comment;
        private Fileset.Type type;
        private Map<String, String> storageLocations = new HashMap<String, String>();
        private Map<String, String> properties;
        private AuditDTO audit;

        private FilesetDTOBuilder() {
        }

        public FilesetDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FilesetDTOBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public FilesetDTOBuilder type(Fileset.Type type) {
            this.type = type;
            return this;
        }

        public FilesetDTOBuilder storageLocations(Map<String, String> storageLocations) {
            this.storageLocations = ImmutableMap.copyOf(storageLocations);
            return this;
        }

        public FilesetDTOBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public FilesetDTOBuilder audit(AuditDTO audit) {
            this.audit = audit;
            return this;
        }

        public FilesetDTO build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name cannot be null or empty");
            Preconditions.checkArgument((!this.storageLocations.isEmpty() ? 1 : 0) != 0, (Object)"storage locations cannot be empty. At least one location is required.");
            this.storageLocations.forEach((n, l) -> {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)n), (Object)"location name cannot be empty");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)l), (Object)"storage location cannot be empty");
            });
            return new FilesetDTO(this.name, this.comment, this.type, this.storageLocations.get("unknown"), this.storageLocations, this.properties, this.audit);
        }
    }
}

