/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.jdbc;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;

public class JdbcMetadataObject
implements AuthorizationMetadataObject {
    private final String parent;
    private final String name;
    private final Type type;

    public JdbcMetadataObject(String parent, String name, Type type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    @Nullable
    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public List<String> names() {
        return DOT_SPLITTER.splitToList((CharSequence)this.fullName());
    }

    public Type type() {
        return this.type;
    }

    public void validateAuthorizationMetadataObject() throws IllegalArgumentException {
        List<String> names = this.names();
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"The name of the object is empty.");
        Preconditions.checkArgument((names.size() <= 2 ? 1 : 0) != 0, (Object)"The name of the object is not in the format of 'database.table'.");
        Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"The type of the object is null.");
        if (names.size() == 1) {
            Preconditions.checkArgument((this.type.metadataObjectType() == MetadataObject.Type.SCHEMA ? 1 : 0) != 0, (Object)"The type of the object is not SCHEMA.");
        } else {
            Preconditions.checkArgument((this.type.metadataObjectType() == MetadataObject.Type.TABLE ? 1 : 0) != 0, (Object)"The type of the object is not TABLE.");
        }
        for (String name : names) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with null name");
        }
    }

    public static enum Type implements AuthorizationMetadataObject.Type
    {
        SCHEMA(MetadataObject.Type.SCHEMA),
        TABLE(MetadataObject.Type.TABLE);

        private final MetadataObject.Type metadataType;

        private Type(MetadataObject.Type type) {
            this.metadataType = type;
        }

        public MetadataObject.Type metadataObjectType() {
            return this.metadataType;
        }

        public static Type fromMetadataType(MetadataObject.Type metadataType) {
            for (Type type : Type.values()) {
                if (type.metadataObjectType() != metadataType) continue;
                return type;
            }
            throw new IllegalArgumentException("No matching JdbcMetadataObject.Type for " + String.valueOf(metadataType));
        }
    }
}

