/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hive.HiveSchemaConverter;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class HiveSchemaUtil {
    private HiveSchemaUtil() {
    }

    public static List<FieldSchema> convert(Schema schema) {
        return schema.columns().stream().map(col -> new FieldSchema(col.name(), HiveSchemaUtil.convertToTypeString(col.type()), col.doc())).collect(Collectors.toList());
    }

    public static Schema convert(List<FieldSchema> fieldSchemas) {
        return HiveSchemaUtil.convert(fieldSchemas, false);
    }

    public static Schema convert(List<FieldSchema> fieldSchemas, boolean autoConvert) {
        ArrayList names = Lists.newArrayListWithExpectedSize((int)fieldSchemas.size());
        ArrayList typeInfos = Lists.newArrayListWithExpectedSize((int)fieldSchemas.size());
        ArrayList comments = Lists.newArrayListWithExpectedSize((int)fieldSchemas.size());
        for (FieldSchema col : fieldSchemas) {
            names.add(col.getName());
            typeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString((String)col.getType()));
            comments.add(col.getComment());
        }
        return HiveSchemaConverter.convert(names, typeInfos, comments, autoConvert);
    }

    public static PartitionSpec spec(Schema schema, List<FieldSchema> fieldSchemas) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        fieldSchemas.forEach(fieldSchema -> builder.identity(fieldSchema.getName()));
        return builder.build();
    }

    public static Schema convert(List<String> names, List<TypeInfo> types, List<String> comments) {
        return HiveSchemaConverter.convert(names, types, comments, false);
    }

    public static Schema convert(List<String> names, List<TypeInfo> types, List<String> comments, boolean autoConvert) {
        return HiveSchemaConverter.convert(names, types, comments, autoConvert);
    }

    public static TypeInfo convert(Type type) {
        return TypeInfoUtils.getTypeInfoFromTypeString((String)HiveSchemaUtil.convertToTypeString(type));
    }

    public static Type convert(TypeInfo typeInfo) {
        return HiveSchemaConverter.convert(typeInfo, false);
    }

    private static String convertToTypeString(Type type) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "int";
            }
            case LONG: {
                return "bigint";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case TIME: 
            case STRING: 
            case UUID: {
                return "string";
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)type;
                if (HiveVersion.min(HiveVersion.HIVE_3) && timestampType.shouldAdjustToUTC()) {
                    return "timestamp with local time zone";
                }
                return "timestamp";
            }
            case FIXED: 
            case BINARY: {
                return "binary";
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return String.format("decimal(%s,%s)", decimalType.precision(), decimalType.scale());
            }
            case STRUCT: {
                Types.StructType structType = type.asStructType();
                String nameToType = structType.fields().stream().map(f -> String.format("%s:%s", f.name(), HiveSchemaUtil.convert(f.type()))).collect(Collectors.joining(","));
                return String.format("struct<%s>", nameToType);
            }
            case LIST: {
                Types.ListType listType = type.asListType();
                return String.format("array<%s>", HiveSchemaUtil.convert(listType.elementType()));
            }
            case MAP: {
                Types.MapType mapType = type.asMapType();
                return String.format("map<%s,%s>", HiveSchemaUtil.convert(mapType.keyType()), HiveSchemaUtil.convert(mapType.valueType()));
            }
        }
        throw new UnsupportedOperationException(String.valueOf(type) + " is not supported");
    }
}

