/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.Dataset;
import java.io.IOException;
import java.util.Optional;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ArrowReader;

public class SqlQuery {
    private static final String DEFAULT_TABLE_NAME = "dataset";
    private Dataset dataset;
    private String sql;
    private String table = "dataset";
    private boolean withRowId = false;
    private boolean withRowAddr = false;

    public SqlQuery(Dataset dataset, String sql) {
        this.dataset = dataset;
        this.sql = sql;
    }

    public SqlQuery tableName(String tableName) {
        this.table = tableName;
        return this;
    }

    public SqlQuery withRowId(boolean withRowId) {
        this.withRowId = withRowId;
        return this;
    }

    public SqlQuery withRowAddr(boolean withAddr) {
        this.withRowAddr = withAddr;
        return this;
    }

    public ArrowReader intoBatchRecords() throws IOException {
        try (ArrowArrayStream s = ArrowArrayStream.allocateNew((BufferAllocator)this.dataset.allocator());){
            SqlQuery.intoBatchRecords(this.dataset, this.sql, Optional.ofNullable(this.table), this.withRowId, this.withRowAddr, s.memoryAddress());
            ArrowReader arrowReader = Data.importArrayStream((BufferAllocator)this.dataset.allocator(), (ArrowArrayStream)s);
            return arrowReader;
        }
    }

    private static native void intoBatchRecords(Dataset var0, String var1, Optional<String> var2, boolean var3, boolean var4, long var5) throws IOException;
}

