/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index.vector;

import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class HnswBuildParams {
    private final short maxLevel;
    private final int m;
    private final int efConstruction;
    private final Optional<Integer> prefetchDistance;

    private HnswBuildParams(Builder builder) {
        this.maxLevel = builder.maxLevel;
        this.m = builder.m;
        this.efConstruction = builder.efConstruction;
        this.prefetchDistance = builder.prefetchDistance;
    }

    public short getMaxLevel() {
        return this.maxLevel;
    }

    public int getM() {
        return this.m;
    }

    public int getEfConstruction() {
        return this.efConstruction;
    }

    public Optional<Integer> getPrefetchDistance() {
        return this.prefetchDistance;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("maxLevel", this.maxLevel).append("m", this.m).append("efConstruction", this.efConstruction).append("prefetchDistance", this.prefetchDistance.orElse(null)).toString();
    }

    public static class Builder {
        private short maxLevel = (short)7;
        private int m = 20;
        private int efConstruction = 150;
        private Optional<Integer> prefetchDistance = Optional.of(2);

        public Builder setMaxLevel(short maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public Builder setM(int m) {
            this.m = m;
            return this;
        }

        public Builder setEfConstruction(int efConstruction) {
            this.efConstruction = efConstruction;
            return this;
        }

        public Builder setPrefetchDistance(Integer prefetchDistance) {
            this.prefetchDistance = Optional.ofNullable(prefetchDistance);
            return this;
        }

        public HnswBuildParams build() {
            return new HnswBuildParams(this);
        }
    }
}

