/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.base.Joiner;
import java.util.Collections;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;

public class CreateRole
extends Command {
    protected String metalake;
    protected String[] roles;

    public CreateRole(CommandContext context, String metalake, String[] roles) {
        super(context);
        this.metalake = metalake;
        this.roles = roles;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            for (String role : this.roles) {
                client.createRole(role, null, Collections.EMPTY_LIST);
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (RoleAlreadyExistsException err) {
            this.exitWithError("Role already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(Joiner.on(", ").join(this.roles) + " created");
    }
}

