/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class DeleteCatalog
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final boolean force;

    public DeleteCatalog(CommandContext context, String metalake, String catalog) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.catalog = catalog;
    }

    @Override
    public void handle() {
        boolean deleted = false;
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            deleted = client.dropCatalog(this.catalog);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (CatalogInUseException catalogInUseException) {
            System.err.println(this.catalog + " in use, please disable it first.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation(this.catalog + " deleted.");
        } else {
            this.printInformation(this.catalog + " not deleted.");
        }
    }
}

