/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.ListProperties;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.Table;

public class ListTableProperties
extends ListProperties {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;

    public ListTableProperties(CommandContext context, String metalake, String catalog, String schema, String table) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void handle() {
        Table gTable = null;
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            GravitinoClient client = this.buildClient(this.metalake);
            gTable = client.loadCatalog(this.catalog).asTableCatalog().loadTable(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        Map<String, String> properties = gTable.properties();
        this.printProperties(properties);
    }
}

