/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class RemoveMetalakeProperty
extends Command {
    protected final String metalake;
    protected final String property;

    public RemoveMetalakeProperty(CommandContext context, String metalake, String property) {
        super(context);
        this.metalake = metalake;
        this.property = property;
    }

    @Override
    public void handle() {
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            MetalakeChange change = MetalakeChange.removeProperty(this.property);
            client.alterMetalake(this.metalake, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.property + " property removed.");
    }

    @Override
    public Command validate() {
        this.validateProperty(this.property);
        return super.validate();
    }
}

