/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.AuditCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.TableCatalog;

public class TableCommand
extends AuditCommand {
    protected final String metalake;
    protected final String catalog;

    public TableCommand(CommandContext context, String metalake, String catalog) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
    }

    @Override
    public void handle() {
    }

    public TableCatalog tableCatalog() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            return client.loadMetalake(this.metalake).loadCatalog(this.catalog).asTableCatalog();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        return null;
    }
}

