/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class UpdateMetalakeName
extends Command {
    protected final String metalake;
    protected final String name;
    protected final boolean force;

    public UpdateMetalakeName(CommandContext context, String metalake, String name) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.name = name;
    }

    @Override
    public void handle() {
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            MetalakeChange change = MetalakeChange.rename(this.name);
            client.alterMetalake(this.metalake, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.metalake + " name changed.");
    }
}

