/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.collect.Lists;
import java.util.Objects;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.TagAlreadyAssociatedException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

public class GenericColumn
implements Column,
SupportsTags {
    private final Column internalColumn;
    private final MetadataObjectTagOperations objectTagOperations;

    GenericColumn(Column column, RESTClient restClient, String metalake, String catalog, String schema, String table) {
        this.internalColumn = column;
        MetadataObject columnObject = MetadataObjects.of(Lists.newArrayList(catalog, schema, table, this.internalColumn.name()), MetadataObject.Type.COLUMN);
        this.objectTagOperations = new MetadataObjectTagOperations(metalake, columnObject, restClient);
    }

    @Override
    public SupportsTags supportsTags() {
        return this;
    }

    @Override
    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    @Override
    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    @Override
    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) throws TagAlreadyAssociatedException {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    @Override
    public String name() {
        return this.internalColumn.name();
    }

    @Override
    public Type dataType() {
        return this.internalColumn.dataType();
    }

    @Override
    public String comment() {
        return this.internalColumn.comment();
    }

    @Override
    public boolean nullable() {
        return this.internalColumn.nullable();
    }

    @Override
    public boolean autoIncrement() {
        return this.internalColumn.autoIncrement();
    }

    @Override
    public Expression defaultValue() {
        return this.internalColumn.defaultValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericColumn)) {
            return false;
        }
        GenericColumn column = (GenericColumn)obj;
        return Objects.equals(this.internalColumn, column.internalColumn);
    }

    public int hashCode() {
        return this.internalColumn.hashCode();
    }
}

